/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.repo.auth.webapp.inject.modules;

import com.google.common.base.Preconditions;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.sun.jersey.guice.JerseyServletModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import gr.cite.repo.auth.app.config.SamlSecurityConfiguration;
import gr.cite.repo.auth.app.config.Security;
import gr.cite.repo.auth.app.entities.SamlResourceFactory;
import gr.cite.repo.auth.app.resources.SAMLResource;
import gr.cite.repo.auth.webapp.inject.modules.ViewMessageBodyWriterProvider;
import gr.cite.repo.auth.webapp.inject.providers.SecurityFilterWrapper;
import java.util.ArrayList;
import java.util.List;

public class SamlSecureServletModule
extends JerseyServletModule {
    protected final SamlSecurityConfiguration configuration;

    public SamlSecureServletModule(SamlSecurityConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void configureServlets() {
        this.serve("/*", new String[0]).with(GuiceContainer.class);
        this.applyFilter(new SecurityFilterWrapper(this.configuration));
        this.bind(SamlResourceFactory.class).in(Scopes.SINGLETON);
        this.bind(ViewMessageBodyWriterProvider.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    SAMLResource samlResourceProvider(SamlResourceFactory samlResourceFactory) {
        Security securityConfiguration = this.configuration.getSecurity();
        Preconditions.checkNotNull((Object)securityConfiguration);
        Preconditions.checkNotNull((Object)samlResourceFactory);
        SAMLResource samlResource = null;
        try {
            samlResource = samlResourceFactory.create(securityConfiguration.getSpHost(), securityConfiguration.getIdpMetadataLocation(), securityConfiguration.getPrivateKeyFilename(), securityConfiguration.getCertificateFilename(), securityConfiguration.getInvalidateLocalSessionOnSamlError(), securityConfiguration.getTryRenewSessionOnLogout(), securityConfiguration.getBulkLogout());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return samlResource;
    }

    void applyFilter(SecurityFilterWrapper filterProvider) {
        List<String> urls = filterProvider.getProtectedUrls();
        String first = urls.get(0);
        ArrayList rest = urls.size() > 1 ? urls.subList(1, urls.size()) : new ArrayList();
        this.filter(first, rest.toArray(new String[0])).through(filterProvider.getFilter());
    }
}

