/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.grsf.services.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gr.forth.ics.isl.grsf.services.exceptions.RequestBodyException;
import gr.forth.ics.isl.grsf.services.model.Connection;
import gr.forth.ics.isl.grsf.services.model.RequestBody;
import gr.forth.ics.isl.grsf.services.model.SimilarRecord;
import gr.forth.ics.isl.grsfservicescore.model.ControlledVocabularies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RequestBody {
    private static final Logger log = Logger.getLogger(RequestBody.class);
    @JsonProperty(value="catalog_id")
    private String catalogId;
    @JsonProperty(value="knowledge_base_id")
    private String knowledgeBaseId;
    @JsonProperty(value="old_status")
    private ControlledVocabularies.ResourceStatus oldStatus;
    @JsonProperty(value="new_status")
    private ControlledVocabularies.ResourceStatus newStatus;
    @JsonProperty(value="annotation_message")
    private String annotationMessage;
    @JsonProperty(value="short_name_old")
    private String shortNameOld;
    @JsonProperty(value="short_name_new")
    private String shortNameNew;
    @JsonProperty(value="grsf_type_old")
    private String grsfTypeOld;
    @JsonProperty(value="grsf_type_new")
    private String grsfTypeNew;
    @JsonProperty(value="traceability_flag")
    private boolean traceable;
    @JsonProperty(value="sdg_flag")
    private boolean sdg;
    @JsonProperty(value="administrator_name")
    private String administratorName;
    @JsonProperty(value="similar_grsf_records")
    private List<SimilarRecord> similarRecords = new ArrayList();
    @JsonProperty(value="connections")
    private List<Connection> connections = new ArrayList();

    public String getAnnotationMessage() {
        if (this.annotationMessage != null) {
            return this.annotationMessage.replaceAll("\n", " ").replaceAll("\t", " ");
        }
        return this.annotationMessage;
    }

    public void setOldStatus(String oldStatus) throws RequestBodyException {
        log.debug((Object)("Defining the old status of the resource record using the string value " + oldStatus));
        this.oldStatus = ControlledVocabularies.getResourceStatus((String)oldStatus);
    }

    public void setNewStatus(String newStatus) throws RequestBodyException {
        log.debug((Object)("Defining the new status of the resource record using the string value " + newStatus));
        this.newStatus = ControlledVocabularies.getResourceStatus((String)newStatus);
    }

    public boolean isStatusChanged() {
        return this.getOldStatus() != this.getNewStatus();
    }

    public boolean isNameChanged() {
        return !this.getShortNameOld().equalsIgnoreCase(this.getShortNameNew());
    }

    public boolean isTypeChanged() {
        return !this.getGrsfTypeOld().equalsIgnoreCase(this.getGrsfTypeNew());
    }

    public boolean hasConnections() {
        return !this.connections.isEmpty();
    }

    public boolean hasUpdatedConnectionsToBeConnected() {
        return this.getConnections().stream().anyMatch(connection -> !connection.isToBeRemoved());
    }

    public boolean hasUpdatedConnectionsToBeRemoved() {
        return this.getConnections().stream().anyMatch(connetion -> connetion.isToBeRemoved());
    }

    public Collection<String> getConnectionsToBeRemoved() {
        return this.getConnections().stream().filter(connection -> connection.isToBeRemoved()).map(Connection::getDestKnowledgeBaseId).collect(Collectors.toList());
    }

    public Collection<String> getConnectionsToBeConnected() {
        return this.getConnections().stream().filter(connection -> !connection.isToBeRemoved()).map(Connection::getDestKnowledgeBaseId).collect(Collectors.toList());
    }

    public Collection<String> getConnectionUUIDs() {
        return this.getConnections().stream().map(Connection::getDestKnowledgeBaseId).collect(Collectors.toList());
    }

    public boolean hasMergeEvents() {
        return this.getSimilarRecords().stream().anyMatch(similarRecord -> similarRecord.isMerge());
    }

    public Collection<String> getSimilarRecordsToBeMerged() {
        return this.getSimilarRecords().stream().filter(simRecord -> simRecord.isMerge()).map(SimilarRecord::getKnowledgeBaseId).collect(Collectors.toList());
    }

    public Collection<String> getSimilarRecordsUUIDs() {
        return this.getSimilarRecords().stream().map(SimilarRecord::getKnowledgeBaseId).collect(Collectors.toList());
    }

    public Collection<String> fetchAllUUIDs() {
        HashSet<String> retCollection = new HashSet<String>();
        retCollection.add(this.getKnowledgeBaseId());
        retCollection.addAll(this.getConnectionUUIDs());
        retCollection.addAll(this.getSimilarRecordsUUIDs());
        return retCollection;
    }

    public void validateRequestBean() throws RequestBodyException {
        if (this.catalogId == null || this.catalogId.isEmpty()) {
            throw new RequestBodyException("Empty value for the field catalog_id");
        }
        if (this.knowledgeBaseId == null || this.knowledgeBaseId.isEmpty()) {
            throw new RequestBodyException("Empty value for the field knowledge_base_id");
        }
        if (this.oldStatus == ControlledVocabularies.ResourceStatus.UNDEF) {
            throw new RequestBodyException("Undefined value for the field old_status");
        }
        if (this.newStatus == ControlledVocabularies.ResourceStatus.UNDEF) {
            throw new RequestBodyException("Undefined value for the field new_status");
        }
        if (this.shortNameOld == null || this.shortNameOld.isEmpty()) {
            throw new RequestBodyException("Empty value for the field short_name_old");
        }
        if (this.shortNameNew == null || this.shortNameNew.isEmpty()) {
            throw new RequestBodyException("Empty value for the field short_name_new");
        }
        if (this.administratorName == null || this.administratorName.isEmpty()) {
            throw new RequestBodyException("Empty value for the field administrator_name");
        }
        for (SimilarRecord similarRecord : this.getSimilarRecords()) {
            similarRecord.validateRequestBean();
        }
        for (Connection connection : this.getConnections()) {
            connection.validateRequestBean();
            if (this.getKnowledgeBaseId().equals(connection.getSourceKnowledgeBaseId())) continue;
            String errorMsg = "The knowledge_base_id value is different from the source_knowledge_base_id value (found in connections)";
            log.error((Object)errorMsg);
            throw new RequestBodyException(errorMsg);
        }
    }

    public void validateRecordTypes(ControlledVocabularies.ResourceType recordType) throws RequestBodyException {
        switch (1.$SwitchMap$gr$forth$ics$isl$grsfservicescore$model$ControlledVocabularies$ResourceType[recordType.ordinal()]) {
            case 1: {
                if (ControlledVocabularies.getStockType((String)this.grsfTypeOld) != ControlledVocabularies.StockType.ASSESSMENT_UNIT && ControlledVocabularies.getStockType((String)this.grsfTypeOld) != ControlledVocabularies.StockType.MARINE_RESOURCE) {
                    throw new RequestBodyException("Unable to recognize the old type of the record with value: " + this.grsfTypeOld + ". The following values are allowed: [" + ControlledVocabularies.StockType.ASSESSMENT_UNIT + ", " + ControlledVocabularies.StockType.MARINE_RESOURCE + "]");
                }
                if (ControlledVocabularies.getStockType((String)this.grsfTypeNew) == ControlledVocabularies.StockType.ASSESSMENT_UNIT || ControlledVocabularies.getStockType((String)this.grsfTypeNew) == ControlledVocabularies.StockType.MARINE_RESOURCE) break;
                throw new RequestBodyException("Unable to recognize the new type of the record with value: " + this.grsfTypeOld + ". The following values are allowed: [" + ControlledVocabularies.StockType.ASSESSMENT_UNIT + ", " + ControlledVocabularies.StockType.MARINE_RESOURCE + "]");
            }
            case 2: {
                if (ControlledVocabularies.getFisheryType((String)this.grsfTypeOld) != ControlledVocabularies.FisheryType.FISHING_UNIT && ControlledVocabularies.getFisheryType((String)this.grsfTypeOld) != ControlledVocabularies.FisheryType.OTHER_FISHERY) {
                    throw new RequestBodyException("Unable to recognize the old type of the record with value: " + this.grsfTypeOld + ". The following values are allowed: [" + ControlledVocabularies.FisheryType.FISHING_UNIT + ", " + ControlledVocabularies.FisheryType.FISHING_UNIT + "]");
                }
                if (ControlledVocabularies.getFisheryType((String)this.grsfTypeNew) == ControlledVocabularies.FisheryType.FISHING_UNIT || ControlledVocabularies.getFisheryType((String)this.grsfTypeNew) == ControlledVocabularies.FisheryType.OTHER_FISHERY) break;
                throw new RequestBodyException("Unable to recognize the new type of the record with value: " + this.grsfTypeOld + ". The following values are allowed: [" + ControlledVocabularies.FisheryType.FISHING_UNIT + ", " + ControlledVocabularies.FisheryType.FISHING_UNIT + "]");
            }
        }
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("catalog_id", this.getCatalogId());
        jsonObject.addProperty("knowledge_base_id", this.getKnowledgeBaseId());
        jsonObject.addProperty("old_status", this.getOldStatus().toString());
        jsonObject.addProperty("new_status", this.getNewStatus().toString());
        jsonObject.addProperty("short_name_old", this.getShortNameOld());
        jsonObject.addProperty("short_name_new", this.getShortNameNew());
        jsonObject.addProperty("grsf_type_old", this.getGrsfTypeOld());
        jsonObject.addProperty("grsf_type_new", this.getGrsfTypeNew());
        jsonObject.addProperty("traceability_flag", Boolean.valueOf(this.isTraceable()));
        jsonObject.addProperty("sdg_flag", Boolean.valueOf(this.isSdg()));
        jsonObject.addProperty("administrator_name", this.getAdministratorName());
        jsonObject.addProperty("annotation_message", this.getAnnotationMessage());
        JsonArray similarRecordsArray = new JsonArray();
        this.getSimilarRecords().forEach(similarRecord -> similarRecordsArray.add((JsonElement)similarRecord.toJson()));
        jsonObject.add("similar_grsf_records", (JsonElement)similarRecordsArray);
        JsonArray connectionsArray = new JsonArray();
        this.getConnections().forEach(connection -> connectionsArray.add((JsonElement)connection.toJson()));
        jsonObject.add("connections", (JsonElement)connectionsArray);
        return jsonObject;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public ControlledVocabularies.ResourceStatus getOldStatus() {
        return this.oldStatus;
    }

    public ControlledVocabularies.ResourceStatus getNewStatus() {
        return this.newStatus;
    }

    public String getShortNameOld() {
        return this.shortNameOld;
    }

    public String getShortNameNew() {
        return this.shortNameNew;
    }

    public String getGrsfTypeOld() {
        return this.grsfTypeOld;
    }

    public String getGrsfTypeNew() {
        return this.grsfTypeNew;
    }

    public boolean isTraceable() {
        return this.traceable;
    }

    public boolean isSdg() {
        return this.sdg;
    }

    public String getAdministratorName() {
        return this.administratorName;
    }

    public List<SimilarRecord> getSimilarRecords() {
        return this.similarRecords;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public void setAnnotationMessage(String annotationMessage) {
        this.annotationMessage = annotationMessage;
    }

    public void setShortNameOld(String shortNameOld) {
        this.shortNameOld = shortNameOld;
    }

    public void setShortNameNew(String shortNameNew) {
        this.shortNameNew = shortNameNew;
    }

    public void setGrsfTypeOld(String grsfTypeOld) {
        this.grsfTypeOld = grsfTypeOld;
    }

    public void setGrsfTypeNew(String grsfTypeNew) {
        this.grsfTypeNew = grsfTypeNew;
    }

    public void setTraceable(boolean traceable) {
        this.traceable = traceable;
    }

    public void setSdg(boolean sdg) {
        this.sdg = sdg;
    }

    public void setAdministratorName(String administratorName) {
        this.administratorName = administratorName;
    }

    public void setSimilarRecords(List<SimilarRecord> similarRecords) {
        this.similarRecords = similarRecords;
    }

    public void setConnections(List<Connection> connections) {
        this.connections = connections;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestBody)) {
            return false;
        }
        RequestBody other = (RequestBody)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$catalogId = this.getCatalogId();
        String other$catalogId = other.getCatalogId();
        if (this$catalogId == null ? other$catalogId != null : !this$catalogId.equals(other$catalogId)) {
            return false;
        }
        String this$knowledgeBaseId = this.getKnowledgeBaseId();
        String other$knowledgeBaseId = other.getKnowledgeBaseId();
        if (this$knowledgeBaseId == null ? other$knowledgeBaseId != null : !this$knowledgeBaseId.equals(other$knowledgeBaseId)) {
            return false;
        }
        ControlledVocabularies.ResourceStatus this$oldStatus = this.getOldStatus();
        ControlledVocabularies.ResourceStatus other$oldStatus = other.getOldStatus();
        if (this$oldStatus == null ? other$oldStatus != null : !this$oldStatus.equals(other$oldStatus)) {
            return false;
        }
        ControlledVocabularies.ResourceStatus this$newStatus = this.getNewStatus();
        ControlledVocabularies.ResourceStatus other$newStatus = other.getNewStatus();
        if (this$newStatus == null ? other$newStatus != null : !this$newStatus.equals(other$newStatus)) {
            return false;
        }
        String this$annotationMessage = this.getAnnotationMessage();
        String other$annotationMessage = other.getAnnotationMessage();
        if (this$annotationMessage == null ? other$annotationMessage != null : !this$annotationMessage.equals(other$annotationMessage)) {
            return false;
        }
        String this$shortNameOld = this.getShortNameOld();
        String other$shortNameOld = other.getShortNameOld();
        if (this$shortNameOld == null ? other$shortNameOld != null : !this$shortNameOld.equals(other$shortNameOld)) {
            return false;
        }
        String this$shortNameNew = this.getShortNameNew();
        String other$shortNameNew = other.getShortNameNew();
        if (this$shortNameNew == null ? other$shortNameNew != null : !this$shortNameNew.equals(other$shortNameNew)) {
            return false;
        }
        String this$grsfTypeOld = this.getGrsfTypeOld();
        String other$grsfTypeOld = other.getGrsfTypeOld();
        if (this$grsfTypeOld == null ? other$grsfTypeOld != null : !this$grsfTypeOld.equals(other$grsfTypeOld)) {
            return false;
        }
        String this$grsfTypeNew = this.getGrsfTypeNew();
        String other$grsfTypeNew = other.getGrsfTypeNew();
        if (this$grsfTypeNew == null ? other$grsfTypeNew != null : !this$grsfTypeNew.equals(other$grsfTypeNew)) {
            return false;
        }
        if (this.isTraceable() != other.isTraceable()) {
            return false;
        }
        if (this.isSdg() != other.isSdg()) {
            return false;
        }
        String this$administratorName = this.getAdministratorName();
        String other$administratorName = other.getAdministratorName();
        if (this$administratorName == null ? other$administratorName != null : !this$administratorName.equals(other$administratorName)) {
            return false;
        }
        List this$similarRecords = this.getSimilarRecords();
        List other$similarRecords = other.getSimilarRecords();
        if (this$similarRecords == null ? other$similarRecords != null : !((Object)this$similarRecords).equals(other$similarRecords)) {
            return false;
        }
        List this$connections = this.getConnections();
        List other$connections = other.getConnections();
        return !(this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catalogId = this.getCatalogId();
        result = result * 59 + ($catalogId == null ? 43 : $catalogId.hashCode());
        String $knowledgeBaseId = this.getKnowledgeBaseId();
        result = result * 59 + ($knowledgeBaseId == null ? 43 : $knowledgeBaseId.hashCode());
        ControlledVocabularies.ResourceStatus $oldStatus = this.getOldStatus();
        result = result * 59 + ($oldStatus == null ? 43 : $oldStatus.hashCode());
        ControlledVocabularies.ResourceStatus $newStatus = this.getNewStatus();
        result = result * 59 + ($newStatus == null ? 43 : $newStatus.hashCode());
        String $annotationMessage = this.getAnnotationMessage();
        result = result * 59 + ($annotationMessage == null ? 43 : $annotationMessage.hashCode());
        String $shortNameOld = this.getShortNameOld();
        result = result * 59 + ($shortNameOld == null ? 43 : $shortNameOld.hashCode());
        String $shortNameNew = this.getShortNameNew();
        result = result * 59 + ($shortNameNew == null ? 43 : $shortNameNew.hashCode());
        String $grsfTypeOld = this.getGrsfTypeOld();
        result = result * 59 + ($grsfTypeOld == null ? 43 : $grsfTypeOld.hashCode());
        String $grsfTypeNew = this.getGrsfTypeNew();
        result = result * 59 + ($grsfTypeNew == null ? 43 : $grsfTypeNew.hashCode());
        result = result * 59 + (this.isTraceable() ? 79 : 97);
        result = result * 59 + (this.isSdg() ? 79 : 97);
        String $administratorName = this.getAdministratorName();
        result = result * 59 + ($administratorName == null ? 43 : $administratorName.hashCode());
        List $similarRecords = this.getSimilarRecords();
        result = result * 59 + ($similarRecords == null ? 43 : ((Object)$similarRecords).hashCode());
        List $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        return result;
    }

    public String toString() {
        return "RequestBody(catalogId=" + this.getCatalogId() + ", knowledgeBaseId=" + this.getKnowledgeBaseId() + ", oldStatus=" + this.getOldStatus() + ", newStatus=" + this.getNewStatus() + ", annotationMessage=" + this.getAnnotationMessage() + ", shortNameOld=" + this.getShortNameOld() + ", shortNameNew=" + this.getShortNameNew() + ", grsfTypeOld=" + this.getGrsfTypeOld() + ", grsfTypeNew=" + this.getGrsfTypeNew() + ", traceable=" + this.isTraceable() + ", sdg=" + this.isSdg() + ", administratorName=" + this.getAdministratorName() + ", similarRecords=" + this.getSimilarRecords() + ", connections=" + this.getConnections() + ")";
    }
}

