/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.isl.grsf.services.scheduler;

import gr.forth.ics.isl.grsfservicescore.CatalogScope;
import gr.forth.ics.isl.grsfservicescore.exception.UuidGenerationException;
import gr.forth.ics.isl.grsfservicescore.exception.VirtuosoConnectorException;
import gr.forth.ics.isl.grsfservicescore.merge.RecordsMerger;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.openrdf.repository.RepositoryException;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.BeansException;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class MergeCheck
implements Job {
    private static final Logger log = Logger.getLogger(MergeCheck.class);

    public void execute(JobExecutionContext jec) throws JobExecutionException {
        try {
            log.info((Object)"Checking for pending merge events");
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("beans.xml");
            RecordsMerger merger = new RecordsMerger((CatalogScope)context.getBean("updateClient_scope_bean", CatalogScope.class));
            int hoursPassedForApplicableMerging = (Integer)context.getBean("mergeWaitTimeBean", Integer.class);
            if (hoursPassedForApplicableMerging > 0) {
                Collection applicableMergeEvents = merger.searchForApplicableMergeEvents(((Integer)context.getBean("mergeWaitTimeBean", Integer.class)).intValue());
                if (!applicableMergeEvents.isEmpty()) {
                    merger.applyMerging(applicableMergeEvents);
                } else {
                    log.info((Object)"No applicable merge events were found");
                }
            } else {
                log.info((Object)("Merging has been disabled [Number_of_hours= " + hoursPassedForApplicableMerging + "]"));
            }
        }
        catch (UuidGenerationException | VirtuosoConnectorException | RepositoryException | BeansException ex) {
            log.error((Object)"An error occured while checking for possible merges", ex);
        }
    }
}

