package gr.i2s.bluebridge.simul.model.util;

import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gr.i2s.bluebridge.simul.model.SiteFull;
import gr.i2s.bluebridge.simul.util2.HibernateUtil;

public class SiteFullUtil {
	public static void addSiteFull(SiteFull siteFull) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.save(siteFull);

			session.flush();

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static void deleteSiteFull(long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			SiteFull siteFull = (SiteFull) session.get(SiteFull.class, Long.valueOf(id));

			if (siteFull != null) {
				session.delete(siteFull);

				session.flush();
			}

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static SiteFull getSiteFull(long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			SiteFull siteFull = (SiteFull) session.get(SiteFull.class, Long.valueOf(id));

			session.getTransaction().commit();

			return siteFull;
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static List getSiteFulls(String userId, int start, int end) throws Exception {
		// TODO implement start - end
		_log.warn("not implemented implement start - end !!!");

		Session session = null;

		try {
			_log.trace(String.format("denispyr start getSiteFulls"));
			session = HibernateUtil.openSession();
			_log.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID).setParameter("userid", userId);

			List list = q.list();

			session.getTransaction().commit();

			_log.trace(String.format("denispyr return SiteFulls %s", list));
			return list;
		} catch (Exception e) {
			_log.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static List getSiteFulls(String userId) throws Exception {
		Session session = null;

		try {
			_log.trace(String.format("denispyr start getSiteFulls"));
			session = HibernateUtil.openSession();
			_log.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID).setParameter("userid", userId);

			List list = q.list();

			session.getTransaction().commit();

			_log.trace(String.format("denispyr return SiteFulls %s", list));
			return list;
		} catch (Exception e) {
			_log.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static int getSiteFullCount(String userId) throws Exception {
		// TODO implement start - end
		_log.warn("not implemented implement start - end !!!");
		return 5;
	}

	public static void updateSiteFull(SiteFull siteFull) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			session.update(siteFull);

			session.flush();

			session.getTransaction().commit();
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	// private static final String _GET_ALL_ON_USERID = "SELECT {SiteFullView.*}
	// FROM SiteFullView WHERE userid = :userid ORDER BY designation ASC";
	private static final String _GET_ALL_ON_USERID = "FROM gr.i2s.bluebridge.simul.model.SiteFull s WHERE s.userId = :userid ORDER BY s.designation ASC";
	private static Log _log = LogFactoryUtil.getLog(SiteFullUtil.class);
}
