package gr.i2s.bluebridge.simul.portlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.util.bridges.mvc.MVCPortlet;

import gr.i2s.bluebridge.simul.model.CurrentRating;
import gr.i2s.bluebridge.simul.model.OxygenRating;
import gr.i2s.bluebridge.simul.model.Region;

/**
 * Portlet implementation class ModelerPortlet
 */
public class SitePortlet extends MVCPortlet {
	private static Log logger = LogFactoryUtil.getLog(SitePortlet.class);

	@Override
	public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
		logger.info(String.format("render path [%s]", getPath(request)));

		String path = getPath(request);
		if (path == null || path.endsWith("view.jsp")) {
			logger.trace("Preparing view");

			// https: //
			// www.liferay.com/community/forums/-/message_boards/message/53477656
			// what I really want is to clear the SiteFullView cache
			// but if i use the class, it doesn't work
			// FinderCacheUtil.clearCache();

			String userId = null; // invalid
			try {
				ServiceContext context = ServiceContextFactory.getInstance(request);
				userId = String.valueOf(context.getUserId());
			} catch (SystemException | PortalException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			request.setAttribute("userId", userId);

		} else if (path.endsWith("edit.jsp")) {
			logger.trace("Preparing edit");

			// List<Region> regionList = null;
			// List<OxygenRating> oxygenRatingList = null;
			// List<CurrentRating> currentRatingList = null;
			//
			// try {
			// regionList = new
			// ArrayList<>(RegionLocalServiceUtil.getRegions(QueryUtil.ALL_POS,
			// QueryUtil.ALL_POS));
			// oxygenRatingList = new ArrayList<>(
			// OxygenRatingLocalServiceUtil.getOxygenRatings(QueryUtil.ALL_POS,
			// QueryUtil.ALL_POS));
			// currentRatingList = new ArrayList<>(
			// CurrentRatingLocalServiceUtil.getCurrentRatings(QueryUtil.ALL_POS,
			// QueryUtil.ALL_POS));
			// } catch (SystemException e) {
			// // TODO Auto-generated catch block
			// e.printStackTrace();
			// }
			//
			// if (regionList == null) {
			// regionList = new ArrayList<>();
			// }
			// request.setAttribute("regionList", regionList);
			//
			// if (oxygenRatingList == null) {
			// oxygenRatingList = new ArrayList<>();
			// }
			// request.setAttribute("oxygenRatingList", oxygenRatingList);
			//
			// if (currentRatingList == null) {
			// currentRatingList = new ArrayList<>();
			// }
			// request.setAttribute("currentRatingList", currentRatingList);
		} else {
			logger.trace("Preparing nothing!");

		}

		super.render(request, response);
	}

	public void saveSite(ActionRequest request, ActionResponse response) throws PortalException, SystemException {
		// ServiceContext context =
		// ServiceContextFactory.getInstance(Site.class.getName(), request);
		// String name = ParamUtil.getString(request, "name");
		// Long regionId = ParamUtil.getLong(request, "regionId");
		// Long oxygenRatingId = ParamUtil.getLong(request, "oxygenRatingId");
		// Long currentRatingId = ParamUtil.getLong(request, "currentRatingId");
		// Long periodJanA = ParamUtil.getLong(request, "periodJanA");
		// Long periodJanB = ParamUtil.getLong(request, "periodJanB");
		// Long periodFebA = ParamUtil.getLong(request, "periodFebA");
		// Long periodFebB = ParamUtil.getLong(request, "periodFebB");
		// Long periodMarA = ParamUtil.getLong(request, "periodMarA");
		// Long periodMarB = ParamUtil.getLong(request, "periodMarB");
		// Long periodAprA = ParamUtil.getLong(request, "periodAprA");
		// Long periodAprB = ParamUtil.getLong(request, "periodAprB");
		// Long periodMayA = ParamUtil.getLong(request, "periodMayA");
		// Long periodMayB = ParamUtil.getLong(request, "periodMayB");
		// Long periodJunA = ParamUtil.getLong(request, "periodJunA");
		// Long periodJunB = ParamUtil.getLong(request, "periodJunB");
		// Long periodJulA = ParamUtil.getLong(request, "periodJulA");
		// Long periodJulB = ParamUtil.getLong(request, "periodJulB");
		// Long periodAugA = ParamUtil.getLong(request, "periodAugA");
		// Long periodAugB = ParamUtil.getLong(request, "periodAugB");
		// Long periodSepA = ParamUtil.getLong(request, "periodSepA");
		// Long periodSepB = ParamUtil.getLong(request, "periodSepB");
		// Long periodOctA = ParamUtil.getLong(request, "periodOctA");
		// Long periodOctB = ParamUtil.getLong(request, "periodOctB");
		// Long periodNovA = ParamUtil.getLong(request, "periodNovA");
		// Long periodNovB = ParamUtil.getLong(request, "periodNovB");
		// Long periodDecA = ParamUtil.getLong(request, "periodDecA");
		// Long periodDecB = ParamUtil.getLong(request, "periodDecB");
		// Site site;
		// Long id = ParamUtil.getLong(request, "siteId");
		// if (id > 0) {
		// site = SiteLocalServiceUtil.getSite(id);
		// } else {
		// id = CounterLocalServiceUtil.increment(Site.class.getName());
		// site = SiteUtil.create(id);
		// }
		// site.setName(name);
		// site.setRegionId(regionId);
		// site.setOxygenRatingId(oxygenRatingId);
		// site.setCurrentRatingId(currentRatingId);
		// site.setPeriodJanA(periodJanA);
		// site.setPeriodJanB(periodJanB);
		// site.setPeriodFebA(periodFebA);
		// site.setPeriodFebB(periodFebB);
		// site.setPeriodMarA(periodMarA);
		// site.setPeriodMarB(periodMarB);
		// site.setPeriodAprA(periodAprA);
		// site.setPeriodAprB(periodAprB);
		// site.setPeriodMayA(periodMayA);
		// site.setPeriodMayB(periodMayB);
		// site.setPeriodJunA(periodJunA);
		// site.setPeriodJunB(periodJunB);
		// site.setPeriodJulA(periodJulA);
		// site.setPeriodJulB(periodJulB);
		// site.setPeriodAugA(periodAugA);
		// site.setPeriodAugB(periodAugB);
		// site.setPeriodSepA(periodSepA);
		// site.setPeriodSepB(periodSepB);
		// site.setPeriodOctA(periodOctA);
		// site.setPeriodOctB(periodOctB);
		// site.setPeriodNovA(periodNovA);
		// site.setPeriodNovB(periodNovB);
		// site.setPeriodDecA(periodDecA);
		// site.setPeriodDecB(periodDecB);
		// // Liferay fields
		// site.setGroupId(context.getScopeGroupId());
		// site.setUserId(context.getUserId());
		// site.setCompanyId(context.getCompanyId());
		// site.setCreateDate(context.getCreateDate());
		// site.setModifiedDate(context.getModifiedDate());
		// site.setExpandoBridgeAttributes(context);
		//
		// SiteLocalServiceUtil.updateSite(site);
	}

	public void deleteSite(ActionRequest request, ActionResponse response) throws PortalException, SystemException {
		// long id = ParamUtil.getLong(request, "siteId");
		// logger.debug(String.format("Deleting simulid [%s]", id));
		// SiteLocalServiceUtil.deleteSite(id);

	}

}
