package gr.i2s.bluebridge.simul.model.util;

import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import gr.i2s.bluebridge.simul.model.SiteFull;
import gr.i2s.bluebridge.simul.util2.HibernateUtil;

public class SiteFullUtil {
	public static void add(SiteFull siteFull) throws Exception {
		SiteUtil.add(siteFull);
	}

	public static void update(SiteFull siteFull) throws Exception {
		SiteUtil.update(siteFull);
	}

	public static void delete(long id) throws Exception {
		SiteUtil.delete(id);
	}

	public static SiteFull getSiteFull(long id) throws Exception {
		Session session = null;

		try {
			session = HibernateUtil.openSession();

			session.beginTransaction();

			SiteFull siteFull = (SiteFull) session.get(SiteFull.class, Long.valueOf(id));

			session.getTransaction().commit();

			return siteFull;
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static List getSiteFulls(String userId, int start, int end) throws Exception {
		if (logger.isTraceEnabled()) {
			logger.trace(String.format("reading %s for %s start %s end %s", "SiteFull", userId, start, end));
		}

		Session session = null;

		try {
			logger.trace(String.format("denispyr start getSiteFulls"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID).setParameter("userid", userId);
			if (start > 0)
				q.setFirstResult(start);
			if (end > 0) {
				if (end < start)
					end = start + 1;
				q.setMaxResults(end - start);
			}

			List list = q.list();

			session.getTransaction().commit();

			logger.trace(String.format("denispyr return SiteFulls %s", list));
			return list;
		} catch (Exception e) {
			logger.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static List getSiteFulls(String userId) throws Exception {
		Session session = null;

		try {
			logger.trace(String.format("denispyr start getSiteFulls"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID).setParameter("userid", userId);

			List list = q.list();

			session.getTransaction().commit();

			logger.trace(String.format("denispyr return SiteFulls %s", list));
			return list;
		} catch (Exception e) {
			logger.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	public static int getSiteFullCount(String userId) throws Exception {
		Session session = null;

		try {
			logger.trace(String.format("denispyr start getSiteFulls"));
			session = HibernateUtil.openSession();
			logger.trace(String.format("denispyr session [%s]", session));

			session.beginTransaction();

			Query q = session.createQuery(_GET_ALL_ON_USERID_COUNT).setParameter("userid", userId);

			Number count = (Number) q.uniqueResult();

			session.getTransaction().commit();

			logger.trace(String.format("denispyr return count %s", count));
			return count.intValue();
		} catch (Exception e) {
			logger.error("denispyr", e);
			throw e;
		} finally {
			HibernateUtil.closeSession(session);
		}
	}

	// private static final String _GET_ALL_ON_USERID = "SELECT {SiteFullView.*}
	// FROM SiteFullView WHERE userid = :userid ORDER BY designation ASC";
	private static final String _GET_ALL_ON_USERID = "FROM gr.i2s.bluebridge.simul.model.SiteFull s WHERE s.userId = :userid ORDER BY s.designation ASC";
	private static final String _GET_ALL_ON_USERID_COUNT = "SELECT count(*) FROM gr.i2s.bluebridge.simul.model.SiteFull s WHERE s.userId = :userid";
	private static Log logger = LogFactoryUtil.getLog(SiteFullUtil.class);
}
