package gr.i2s.bluebridge.simul.portlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.util.bridges.mvc.MVCPortlet;

import gr.i2s.bluebridge.simul.model.CurrentRating;
import gr.i2s.bluebridge.simul.model.OxygenRating;
import gr.i2s.bluebridge.simul.model.Region;
import gr.i2s.bluebridge.simul.model.Site;
import gr.i2s.bluebridge.simul.model.util.SiteFullUtil;
import gr.i2s.bluebridge.simul.model.util.SiteUtil;

/**
 * Portlet implementation class ModelerPortlet
 */
public class SitePortlet extends MVCPortlet {
	private static Log logger = LogFactoryUtil.getLog(SitePortlet.class);

	@Override
	public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
		logger.info(String.format("render path [%s]", getPath(request)));

		String path = getPath(request);
		if (path == null || path.endsWith("view.jsp")) {
			logger.trace("Preparing view");

			// https: //
			// www.liferay.com/community/forums/-/message_boards/message/53477656
			// what I really want is to clear the SiteFullView cache
			// but if i use the class, it doesn't work
			// FinderCacheUtil.clearCache();

			String userId = null; // invalid
			try {
				ServiceContext context = ServiceContextFactory.getInstance(request);
				userId = String.valueOf(context.getUserId());
			} catch (SystemException | PortalException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			request.setAttribute("userId", userId);

		} else if (path.endsWith("edit.jsp")) {
			logger.trace("Preparing edit");

			List<Region> regionList = null;
			List<OxygenRating> oxygenRatingList = null;
			List<CurrentRating> currentRatingList = null;

			// try {
			// regionList = new
			// ArrayList<>(RegionLocalServiceUtil.getRegions(QueryUtil.ALL_POS,
			// QueryUtil.ALL_POS));
			// oxygenRatingList = new ArrayList<>(
			// OxygenRatingLocalServiceUtil.getOxygenRatings(QueryUtil.ALL_POS,
			// QueryUtil.ALL_POS));
			// currentRatingList = new ArrayList<>(
			// CurrentRatingLocalServiceUtil.getCurrentRatings(QueryUtil.ALL_POS,
			// QueryUtil.ALL_POS));
			// } catch (SystemException e) {
			// // TODO Auto-generated catch block
			// e.printStackTrace();
			// }

			if (regionList == null) {
				regionList = new ArrayList<>();
				// TODO denispyr remove sample
				Region a = new Region();
				a.setId(1);
				a.setDesignation("Sample 1");
				regionList.add(a);
				a = new Region();
				a.setId(2);
				a.setDesignation("Sample 2");
				regionList.add(a);
			}
			request.setAttribute("regionList", regionList);

			if (oxygenRatingList == null) {
				oxygenRatingList = new ArrayList<>();
				// TODO denispyr remove sample
				OxygenRating a = new OxygenRating();
				a.setId(1);
				a.setDesignation("Sample 1");
				oxygenRatingList.add(a);
				a = new OxygenRating();
				a.setId(2);
				a.setDesignation("Sample 2");
				oxygenRatingList.add(a);
			}
			request.setAttribute("oxygenRatingList", oxygenRatingList);

			if (currentRatingList == null) {
				currentRatingList = new ArrayList<>();
				// TODO denispyr remove sample
				CurrentRating a = new CurrentRating();
				a.setId(1);
				a.setDesignation("Sample 1");
				currentRatingList.add(a);
				a = new CurrentRating();
				a.setId(2);
				a.setDesignation("Sample 2");
				currentRatingList.add(a);
			}
			request.setAttribute("currentRatingList", currentRatingList);
		} else {
			logger.trace("Preparing nothing!");

		}

		super.render(request, response);
	}

	public void save(ActionRequest request, ActionResponse response) throws Exception {
		ServiceContext context = ServiceContextFactory.getInstance(request);

		Long id = ParamUtil.getLong(request, "id");
		Site site;
		if (id > 0) {
			site = SiteUtil.getSite(id);
		} else {
			site = new Site();
		}
		String designation = ParamUtil.getString(request, "designation");
		Long regionId = ParamUtil.getLong(request, "regionId");
		Long oxygenRatingId = ParamUtil.getLong(request, "oxygenRatingId");
		Long currentRatingId = ParamUtil.getLong(request, "currentRatingId");
		Integer periodJanA = ParamUtil.getInteger(request, "periodJanA");
		Integer periodJanB = ParamUtil.getInteger(request, "periodJanB");
		Integer periodFebA = ParamUtil.getInteger(request, "periodFebA");
		Integer periodFebB = ParamUtil.getInteger(request, "periodFebB");
		Integer periodMarA = ParamUtil.getInteger(request, "periodMarA");
		Integer periodMarB = ParamUtil.getInteger(request, "periodMarB");
		Integer periodAprA = ParamUtil.getInteger(request, "periodAprA");
		Integer periodAprB = ParamUtil.getInteger(request, "periodAprB");
		Integer periodMayA = ParamUtil.getInteger(request, "periodMayA");
		Integer periodMayB = ParamUtil.getInteger(request, "periodMayB");
		Integer periodJunA = ParamUtil.getInteger(request, "periodJunA");
		Integer periodJunB = ParamUtil.getInteger(request, "periodJunB");
		Integer periodJulA = ParamUtil.getInteger(request, "periodJulA");
		Integer periodJulB = ParamUtil.getInteger(request, "periodJulB");
		Integer periodAugA = ParamUtil.getInteger(request, "periodAugA");
		Integer periodAugB = ParamUtil.getInteger(request, "periodAugB");
		Integer periodSepA = ParamUtil.getInteger(request, "periodSepA");
		Integer periodSepB = ParamUtil.getInteger(request, "periodSepB");
		Integer periodOctA = ParamUtil.getInteger(request, "periodOctA");
		Integer periodOctB = ParamUtil.getInteger(request, "periodOctB");
		Integer periodNovA = ParamUtil.getInteger(request, "periodNovA");
		Integer periodNovB = ParamUtil.getInteger(request, "periodNovB");
		Integer periodDecA = ParamUtil.getInteger(request, "periodDecA");
		Integer periodDecB = ParamUtil.getInteger(request, "periodDecB");

		site.setDesignation(designation);
		site.setRegionId(regionId);
		site.setOxygenRatingId(oxygenRatingId);
		site.setCurrentRatingId(currentRatingId);
		site.setPeriodJanA(periodJanA);
		site.setPeriodJanB(periodJanB);
		site.setPeriodFebA(periodFebA);
		site.setPeriodFebB(periodFebB);
		site.setPeriodMarA(periodMarA);
		site.setPeriodMarB(periodMarB);
		site.setPeriodAprA(periodAprA);
		site.setPeriodAprB(periodAprB);
		site.setPeriodMayA(periodMayA);
		site.setPeriodMayB(periodMayB);
		site.setPeriodJunA(periodJunA);
		site.setPeriodJunB(periodJunB);
		site.setPeriodJulA(periodJulA);
		site.setPeriodJulB(periodJulB);
		site.setPeriodAugA(periodAugA);
		site.setPeriodAugB(periodAugB);
		site.setPeriodSepA(periodSepA);
		site.setPeriodSepB(periodSepB);
		site.setPeriodOctA(periodOctA);
		site.setPeriodOctB(periodOctB);
		site.setPeriodNovA(periodNovA);
		site.setPeriodNovB(periodNovB);
		site.setPeriodDecA(periodDecA);
		site.setPeriodDecB(periodDecB);
		site.setUserId(String.valueOf(context.getUserId()));

		if (logger.isTraceEnabled()) {
			logger.trace(String.format("persisting %s", site));
		}

		if (id > 0) {
			SiteUtil.update(site);
		} else {
			SiteUtil.add(site);
		}

	}

	public void delete(ActionRequest request, ActionResponse response) throws Exception {
		long id = ParamUtil.getLong(request, "id");
		logger.debug(String.format("Deleting site [%s]", id));
		SiteFullUtil.delete(id);

	}

}
