package gr.uoa.di.madgik.visualisations.WordCloudGroup.client;

import gr.uoa.di.madgik.visualisations.client.injectors.CssResources;
import gr.uoa.di.madgik.visualisations.client.injectors.JSInjector;
import gr.uoa.di.madgik.visualisations.client.injectors.JsResources;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.dom.client.StyleInjector;
import com.google.gwt.resources.client.TextResource;
import com.google.gwt.resources.client.ClientBundle.Source;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;





public class WordCloudGroup implements EntryPoint{

	private String width;
	private String height;
	private String divID;
	private boolean alreadyVisualised;
	
	
//	private String col = "{\"name\":\"flare\",\"children\":[{\"name\":\"CategoryA\",\"size\":100},{\"name\":\"CategoryB\",\"size\":100},{\"name\":\"CategoryC\",\"size\":100},{\"name\":\"CategoryD\",\"size\":100},{\"name\":\"CategoryE\",\"size\":100},{\"name\":\"CategoryF\",\"size\":100}]}";
//	private String wor = "[{\"key\":\"cat\",\"value\":100},{\"key\":\"mouse\",\"value\":170},{\"key\":\"elephant\",\"value\":67},{\"key\":\"girraffe\",\"value\":92},{\"key\":\"dog\",\"value\":123},{\"key\":\"crocodile\",\"value\":80},{\"key\":\"fish\",\"value\":176}]";

	
	public void onModuleLoad() {

		//inject js/css resources
		JSInjector.inject(JsResources.INSTANCE.d3layoutcloudJS().getText());
		JSInjector.inject(JsResources.INSTANCE.sunburstJS().getText());
		JSInjector.inject(JsResources.INSTANCE.cloudJS().getText());
		JSInjector.inject(JsResources.INSTANCE.wordcloudToolboxJS().getText());
		
		StyleInjector.inject(CssResources.INSTANCE.wordcloudCSS().getText());
		StyleInjector.inject(CssResources.INSTANCE.docVisCSS().getText());
		
		alreadyVisualised = false;
		
	}
	
	
	 // Run this to initiate all the DIVS for the visualisation.	
	public void createWordcloud(String divID, String width, String height) {
		this.divID = divID;
		this.width = width;
		this.height = height;
		createWordcloudJS(divID, width, height);
	}
	
	public static native void createWordcloudJS(String divID, String width, String height) /*-{
		$wnd.d3.select("#"+divID).append("div").attr("id", "wordcloud");
	}-*/;
	
	
	/**
	 * Use this for a single cloud visualisation (just a wordcloud)
	 * @param wordcloudDataJSON
	 * @param width
	 * @param height
	 */
	public void visualiseWordcloud(String wordcloudDataJSON, String width, String height) {
		if(!alreadyVisualised)
			visualiseWordCloudJS(divID, wordcloudDataJSON, width, height, true);
		else
			visualiseWordCloudJS(divID, wordcloudDataJSON, width, height, false);
		alreadyVisualised = true;
	}
	
	public static native void visualiseWordCloudJS(String divID, String wordsJSON, String width, String height, boolean createnew) /*-{
//		$wnd.alert("Trying the visualise visualiseWords");
		$wnd.visualiseWords($wnd.d3.select("#"+divID), width, height, wordsJSON, createnew);
		//$wnd.align();
	}-*/;
	
	
	/**
	 * 
	 * @param originalJSON the json as output by the gCube index
	 * @return the json as 
	 */
	public static native String transformFilterStopwordsJS(String originalJSON) /*-{
		return $wnd.transformFilterStopwords(originalJSON);
	}-*/;
	
	
	 // Run this to initiate all the DIVS for the visualisations.	
	public void createVisualisations(String divID, String width, String height) {
		this.divID = divID;
		this.width = width;
		this.height = height;
		createVisualisationsJS(divID, width, height);
	}
	
	/**
	 * Use this for a group of visualisations (wordcloud with surrounding ring)
	 * @param collectionsJSON
	 * @param wordcloudDataJSON
	 * @param width
	 * @param height
	 */
	public void visualiseCollections(String collectionsJSON, String wordcloudDataJSON, String width, String height) {
		if(!alreadyVisualised)
			visualiseCollectionsJS(divID, collectionsJSON, wordcloudDataJSON, width, height, true);
		else
			visualiseCollectionsJS(divID, collectionsJSON, wordcloudDataJSON, width, height, false);
		alreadyVisualised = true;
	}
	
	
	
	public static native void createVisualisationsJS(String divID, String width, String height) /*-{
		var divElem = $wnd.$("#"+divID);
		divElem.empty(); // clear all the previous content within the div (clear all html)
		divElem.removeAttr("style");  //clear also the styling
		divElem.width(width);
		divElem.height(height);
		
		$wnd.d3.select("#"+divID).append("div").attr("id", "wordcloud");
		$wnd.d3.select("#"+divID).append("div").attr("id", "sunburst");
	}-*/;
	
	
	
	public static native void visualiseCollectionsJS(String divID, String collectionsJSON, String wordsJSON, String width, String height, boolean createnew) /*-{
//		$wnd.alert("Trying the visualiseCollections");
		$wnd.visualiseCollections($wnd.d3.select("#"+divID), width, height, collectionsJSON, createnew);
//		$wnd.alert("Trying the visualise visualiseWords");
		$wnd.visualiseWords($wnd.d3.select("#"+divID), width, height, wordsJSON, createnew);
		$wnd.align($wnd.d3.select("#"+divID));
	}-*/;



}