package it.eng.edison.messages.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import it.eng.edison.messages.server.model.UsersChat;

import java.util.List;


public class Messages implements EntryPoint {

    private final MessagesServiceAsync messagesService = GWT.create(MessagesService.class);

    public void onModuleLoad() {


        messagesService.getUser(new AsyncCallback<UsersChat>() {
            @Override
            public void onFailure(Throwable caught) {

            }

            @Override
            public void onSuccess(UsersChat result) {
                final UsersChat user = result;


                messagesService.userList(new AsyncCallback<List<UsersChat>>() {
                    @Override
                    public void onFailure(Throwable caught) {

                    }

                    @Override
                    public void onSuccess(List<UsersChat> result) {
                        RootPanel.get("chat-div").add(new MessagesUI(result, messagesService, user));
                    }
                });

            }
        });








    }




}
