package it.eng.edison.messages.client;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.event.dom.client.*;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.*;

import it.eng.edison.messages.client.bundle.MessagesCss;
import it.eng.edison.messages.server.model.UsersChat;

import java.util.List;

/**
 * Created by pino on 09/07/2016.
 */
public class MessagesSuggestBox  extends Composite {

    private final MultiWordSuggestOracle oracle = new MultiWordSuggestOracle();

    private List<UsersChat> users = null;
    private UsersChat userSelected = null;
    private SuggestBox suggestBox;
    private int indexElement;
    private MessagesSuggestBox instance;
    private Button remove;

//    static{
//        MessagesCss.INSTANCE.css().ensureInjected();
//    }




    public MessagesSuggestBox(final List<UsersChat> userList,  final MessagesServiceAsync messagesService) {
        instance = this;
        users = userList;
        for (UsersChat user : users) {
            oracle.add(user.getFullName());

        }
        remove = new Button();
        suggestBox =  new SuggestBox(oracle);
       // suggestBox.setStyleName("gwt-SuggestBoxPopup");

        remove.setIcon(IconType.REMOVE_SIGN);
        remove.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                int index = Integer.parseInt( remove.getName() );
                instance.removeFromParent();
                messagesService.removeUserFromList(index, new AsyncCallback<Void>() {
                    @Override
                    public void onFailure(Throwable caught) {

                    }

                    @Override
                    public void onSuccess(Void result) {
                        instance.removeFromParent();
                       // Window.alert(instance.suggestBox.getText() + " eliminato");
                    }
                });

            }
        });


        suggestBox.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>() {
            @Override
            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                UsersChat user = getUserModelBySuggestion(event.getSelectedItem());
                messagesService.addUserToList(user, new AsyncCallback<Integer>() {
                    @Override
                    public void onFailure(Throwable caught) {

                    }

                    @Override
                    public void onSuccess(Integer result) {
                        indexElement = result;
                        remove.setName("" + indexElement);
                    }
                });
            }
        });


        HorizontalPanel suggestPanel = new HorizontalPanel();

        suggestBox.setFocus(true);
        suggestPanel.add(suggestBox);
        suggestPanel.add(remove);
        initWidget(suggestPanel);
    }


    private UsersChat getUserModelBySuggestion(SuggestOracle.Suggestion suggestion) {
        for (UsersChat user : users) {
            if (suggestion.getReplacementString() .compareTo(user.getFullName())  == 0 )
                return user;
        }
        return new UsersChat(0,"no-match","no-match","no-match","no-match","no-match","no-match");
    }

    public int getIndexElement() {
        return indexElement;
    }

    public void setIndexElement(int indexElement) {
        this.indexElement = indexElement;
    }
}
