package it.eng.edison.messages.server;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.model.User;
import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.service.RemoteEventServiceServlet;
import it.eng.edison.messages.client.MessagesService;
import it.eng.edison.messages.client.event.ServerGeneratedMessageEvent;
import it.eng.edison.messages.server.dao.ChatMessagesDao;
import it.eng.edison.messages.server.dao.RegistredUsersDao;
import it.eng.edison.messages.server.model.ChatMessages;
import it.eng.edison.messages.server.model.ChatRoom;
import it.eng.edison.messages.server.model.GuestRoom;
import it.eng.edison.messages.server.model.UsersChat;
import it.eng.edison.messages.server.util.ConnectCassandra;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;


import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.MessageNotificationsThread;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;



//import org.gcube.portal.custom.communitymanager.OrganizationsUtil;

/**
 * The server-side implementation of the RPC service.
 */
@SuppressWarnings("serial")



public class MessagesServiceImpl extends RemoteEventServiceServlet implements MessagesService {

    private static Logger _log = LoggerFactory.getLogger(MessagesServiceImpl.class);
    public static final String TEST_USER = "test.user";

    private String filter = "";
    private static List<UsersChat> listOfRegistredUsers = new ArrayList<UsersChat>();
    private List<UsersChat> listOfSelectedUsers = new ArrayList<UsersChat>();
    private UsersChat user;
    private User userLiferay;
    private static Connection connection;
    private static String pathImage;
    private static String strSqlGetUsers;
    private AstyanaxContext<Keyspace> context;
    private Keyspace keyspace;
    private ConnectCassandra cassandra;



    /**
     * the current ASLSession
     * @return the session
     */

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
        if (user == null) {
            _log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devsec/devVRE");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }
    public String getDevelopmentUser() {
        String user = TEST_USER;
        //		user = "costantino.perciante";
        return user;
    }



    @Override
    public UsersChat getUser() throws IllegalArgumentException{
        String username = null;
        GCubeUser gCubeUser = null;
        HttpSession httpSession = null;
        try {
            httpSession = this.getThreadLocalRequest().getSession();
            username = httpSession.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE).toString();
            gCubeUser =  new LiferayUserManager().getUserByUsername(username) ;

            cassandra = new ConnectCassandra();
            keyspace = cassandra.getKeyspace();


        } catch (Exception e) {
            System.out.println("ERROR  UsersChat getUser() " + e.getMessage());
            e.printStackTrace();
        }
        user = new UsersChat();
        user.setId(gCubeUser.getUserId());
        user.setUrlAvatar(gCubeUser.getUserAvatarURL());
        user.setFullName(gCubeUser.getFullname());
        user.setUserName(gCubeUser.getUsername());
        user.setFirstName(gCubeUser.getFirstName());
        user.setLastName(gCubeUser.getLastName() );
        user.setEmail(gCubeUser.getEmail());

        httpSession.setAttribute("user", user);

        System.out.println("user name " + user.getUserName());

        return user;

    }




    @Override
    public int addUserToList(UsersChat user) throws IllegalArgumentException {
        listOfSelectedUsers.add(user);
        return listOfSelectedUsers.size() - 1;
    }

    @Override
    public void removeUserFromList(int index) throws IllegalArgumentException {
        UsersChat u = listOfSelectedUsers.get(index);
        listOfSelectedUsers.remove(index);
    }


    @Override
    public List<UsersChat> getUsersFromList() throws IllegalArgumentException {
        List<UsersChat> tmpList = new ArrayList<UsersChat>();
        for (UsersChat listOfSelectedUser : listOfSelectedUsers) {
            tmpList.add(listOfSelectedUser);
        }
        listOfSelectedUsers.removeAll(listOfSelectedUsers);
        return tmpList;
    }

    @Override
    public List<UsersChat> userList() throws IllegalArgumentException {
        try {
            connection = DataAccess.getConnection();
            HttpSession httpSession = this.getThreadLocalRequest().getSession();
            UsersChat user = (UsersChat)httpSession.getAttribute("user");
            RegistredUsersDao registredUsersDao = new RegistredUsersDao(connection);
            listOfRegistredUsers = registredUsersDao.getRegisteredUsers(user, strSqlGetUsers);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return listOfRegistredUsers;
    }

    @Override
    public long createRoom() throws IllegalArgumentException {
        List<UsersChat> tmpList = new ArrayList<UsersChat>();
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user = (UsersChat) httpSession.getAttribute("user");

        String names = "";
        int index = 0;
        int listUsersLength = listOfSelectedUsers.size();
        for (int i = 0; i < listOfSelectedUsers.size() ; i++) {
            if( !listOfSelectedUsers.get(i).getLastName().isEmpty()  ) {
                names = names + listOfSelectedUsers.get(i).getLastName() + ",";
                index = index + 1;
                if (index > 3)
                    break;
            }
        }
        if(listUsersLength > 3){
            names = names + "  plus " + (listUsersLength - 4 );
        }
        /////////////////////
        if(names.length() > 0)
            names = names.substring(0, names.length() - 1);
        ///////////////////////////////
        try {
            connection = DataAccess.getConnection();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        cassandra = new ConnectCassandra();
        keyspace = cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(keyspace);
        ChatRoom chatRoom = new ChatRoom();
        GuestRoom guestRoom = null;
        chatRoom.setRoomOwnerId(user.getId());
        chatRoom.setRoomOwner(user.getUserName());
        chatRoom.setRoomOwnerFullName(user.getFullName());
        chatRoom.setNameRoom(names);
        List<GuestRoom> guestRooms = new ArrayList<GuestRoom>();

        for (UsersChat listOfSelectedUser : listOfSelectedUsers) {
            guestRoom = new GuestRoom();
            guestRoom.setGuestId(listOfSelectedUser.getId());
            guestRoom.setGuestName(listOfSelectedUser.getUserName());
            guestRoom.setGuestFullName(listOfSelectedUser.getFullName());
            if(guestRoom.getGuestId() > 0)
                guestRooms.add(guestRoom);
        }
        chatRoom.setGuestList(guestRooms);
        long idRoom = 0;
        if(guestRooms.size() > 0) {
            try {
                idRoom = chatMessagesDao.createRoom(user.getId(), chatRoom);
            } catch (ConnectionException e) {
                e.printStackTrace();
            }
        }
        return idRoom;
    }

    @Override
    public List<ChatRoom> getRoomFromOwner(long idUser) throws IllegalArgumentException {
        List<ChatRoom> rooms = new ArrayList<ChatRoom>();
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user =   (UsersChat)   httpSession.getAttribute("user");
        try {
            connection = DataAccess.getConnection();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        cassandra = new ConnectCassandra();
        keyspace = cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(keyspace);
        try {
            rooms = chatMessagesDao.getRoomFromOwner(user.getId());
        } catch (ConnectionException e) {
            e.printStackTrace();
        }

        return rooms;


    }

    @Override
    public List<ChatRoom> getRoomsFromGuest(long idUser) throws IllegalArgumentException {
        List<ChatRoom> rooms = new ArrayList<ChatRoom>();
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user =   (UsersChat)   httpSession.getAttribute("user");
        try {
            connection = DataAccess.getConnection();
        } catch (SQLException e) {
            e.printStackTrace();
        }
        cassandra = new ConnectCassandra();
        keyspace = cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(keyspace);
        try {
            rooms = chatMessagesDao.getRoomsFromGuest(user.getId());
        } catch (ConnectionException e) {
            e.printStackTrace();
        }

        return rooms;
    }


    @Override
    public List<ChatMessages> getMessagesFromRoom(long idRoom) throws IllegalArgumentException {

        List<ChatMessages> messagesList = new ArrayList<ChatMessages>();
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user =   (UsersChat)   httpSession.getAttribute("user");
        cassandra = new ConnectCassandra();
        keyspace = cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(keyspace);
        try {
            messagesList = chatMessagesDao.getMessagesFromRoom(idRoom);
        } catch (ConnectionException e) {
            e.printStackTrace();
        }


        return messagesList;
    }


    @Override
    public String sendMsg( long idRoom, String message, String uplodaFileName, String contentType) throws IllegalArgumentException {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user = (UsersChat)httpSession.getAttribute("user");
        cassandra = new ConnectCassandra();
        keyspace = cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(keyspace);



        if(contentType.contains("IMAGE") ) ;    //// .startsWith("image"))
        contentType = "image";
        if(contentType.contains("APPLICATION"))
            contentType = contentType.replace("application/" , "");

        System.out.println("contentType " + contentType );


        long[] arrId  = new long[2];
        List<UsersChat> usersChats = new ArrayList<UsersChat>();
        try {
            arrId = chatMessagesDao.insertMessage(idRoom , user.getId(), user.getFullName(), message,uplodaFileName, contentType);
            usersChats = chatMessagesDao.getUserFromRoom(idRoom);
        } catch (Exception e) {
            e.printStackTrace();
        }

        ASLSession aslSession = getASLSession();
        List<GenericItemBean> recipients = new ArrayList<GenericItemBean>();
        for (UsersChat usersChat : usersChats) {
            GenericItemBean genericItemBean = new GenericItemBean();
            genericItemBean.setId(""+usersChat.getId());
            genericItemBean.setName(usersChat.getUserName());
            genericItemBean.setThumbnailURL("");
            recipients.add(genericItemBean);
        }

        String messageId = "" + arrId;
        //decommentare per edison

        SocialNetworkingUser socialNetworkingUser = new SocialNetworkingUser();
        socialNetworkingUser.setEmail(user.getEmail());
        socialNetworkingUser.setUsername(user.getUserName());
        socialNetworkingUser.setFullname(user.getFullName());

        SocialNetworkingSite  socialNetworkingSite = new SocialNetworkingSite(getThreadLocalRequest());

        SocialNetworkingUser userSender = new SocialNetworkingUser(
                aslSession.getUsername(), aslSession.getUserEmailAddress(),
                aslSession.getUserFullName(), aslSession.getUserAvatarId());


        NotificationsManager nm = new ApplicationNotificationsManager(socialNetworkingSite,aslSession.getScope(), userSender);
        Thread thread = new Thread(new MessageNotificationsThread(recipients, messageId, "chat", "invio chat", nm));
        thread.start();

        // fine sezione
        Event theEvent = new ServerGeneratedMessageEvent( "" + arrId[0] + "," + arrId[1] );
        addEvent(ServerGeneratedMessageEvent.SERVER_MESSAGE_DOMAIN, theEvent);
        return "OK";
    }



    @Override
    public ChatMessages getMessage(long idMessage, long idRoomSelected) throws IllegalArgumentException {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user = (UsersChat)httpSession.getAttribute("user");
        cassandra = new ConnectCassandra();
        keyspace = cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(keyspace);
        ChatMessages chatMessage = null;
        try {
            chatMessage = chatMessagesDao.getMessage(idMessage, user.getId(), idRoomSelected);
        } catch (ConnectionException e) {
            e.printStackTrace();
        }
        return chatMessage;
    }


    @Override
    public void deleteUserFromList(long idRoom ) throws IllegalArgumentException {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        UsersChat user = (UsersChat)httpSession.getAttribute("user");
        cassandra = new ConnectCassandra();
        keyspace = cassandra.getKeyspace();
        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(keyspace);
        try {
            chatMessagesDao.deleteUserFromList(idRoom,user.getId());
        } catch (ConnectionException e) {
            e.printStackTrace();
        }
    }


    @Override
    public void addUserToConversation(List<UsersChat> userList, long idRoom) throws IllegalArgumentException {
        GuestRoom guestRoom;
        List<GuestRoom> guestRooms = new ArrayList<GuestRoom>();
        for (UsersChat listOfSelectedUser : userList) {
            guestRoom = new GuestRoom();
            guestRoom.setGuestId(listOfSelectedUser.getId());
            guestRoom.setGuestName(listOfSelectedUser.getUserName());
            guestRoom.setGuestFullName(listOfSelectedUser.getFullName());
            if(guestRoom.getGuestId() > 0)
                guestRooms.add(guestRoom);
        }
        if(guestRooms.size() > 0) {
            cassandra = new ConnectCassandra();
            keyspace = cassandra.getKeyspace();
            ChatMessagesDao chatMessagesDao = new ChatMessagesDao(keyspace);
            try {
                chatMessagesDao.addUserToList(idRoom, guestRooms);
            } catch (ConnectionException e) {
                e.printStackTrace();
            }
        }

    }



//    private String getUserImagePortraitUrlLocal(String screenName) {
//        StringBuilder thumbnailURL = new StringBuilder("/image/user_male_portrait?img_id=");
//        User user = null;
//        try {
//            user = UserLocalServiceUtil.getUserByScreenName(OrganizationsUtil.getCompany().getCompanyId(), screenName);
//        } catch (Exception e) {
//              e.printStackTrace();
//           } catch (SystemException e) {
//            e.printStackTrace();
//        }
//        return thumbnailURL.append(user.getPortraitId()).toString();
//    }


    @Override
    public List<ChatMessages> searchMessage(long idRoom, String string) throws IllegalArgumentException {
        List<ChatMessages> messagesList = new ArrayList<ChatMessages>();
        System.out.println("searchMessage room " + idRoom + " string  " + string);

        ChatMessagesDao chatMessagesDao = new ChatMessagesDao(keyspace);

        try{
            messagesList = chatMessagesDao.searchMessages(string , idRoom);
        } catch (ConnectionException e) {
            e.printStackTrace();
        }


        return messagesList;
    }



}