package it.eng.edison.messages.server.dao;

import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.CqlStatementResult;
import com.netflix.astyanax.model.*;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import it.eng.edison.messages.server.model.ChatMessages;
import it.eng.edison.messages.server.model.ChatRoom;
import it.eng.edison.messages.server.model.GuestRoom;
import it.eng.edison.messages.server.model.UsersChat;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by Administrator on 21/07/2016.
 */
public class ChatMessagesDao {

    private Keyspace keyspace;

    public ChatMessagesDao(Keyspace _keyspace) {
        keyspace = _keyspace;

    }

    public void addUserToList(long idRoom, List<GuestRoom> listUser) throws ConnectionException {
        for (GuestRoom guest : listUser){
            String strSqlGuest = "INSERT INTO guestRoom (idRoom, guestId, guestName, guestFullName ) VALUES ";
            strSqlGuest = strSqlGuest + "( ";
            strSqlGuest = strSqlGuest + idRoom + ",";
            strSqlGuest = strSqlGuest + guest.getGuestId() + ",";
            strSqlGuest = strSqlGuest + "'" + guest.getGuestName() + "',";
            strSqlGuest = strSqlGuest + "'" + guest.getGuestFullName() + "')";
            keyspace.prepareCqlStatement().withCql(strSqlGuest).execute();
        }
    }

    public void deleteUserFromList(long idRoom, long idUser) throws ConnectionException {
        System.out.println("Delete User From room:" + idRoom + " user:" + idUser);

        String strDelete = "DELETE FROM guestroom WHERE idroom = " + idRoom + " AND guestid = " +   idUser;
        String strUpdate = "UPDATE chatroom SET active = false WHERE idroom = " + idRoom + " AND roomOwnerId = " +   idUser;
        String strControl = "SELECT  roomownerid FROM chatroom WHERE roomownerid=" + idUser + " AND idroom=" + idRoom ;

        keyspace.prepareCqlStatement().withCql(strDelete).execute();

        long ownerId = 0;
        CqlStatementResult result = keyspace.prepareCqlStatement().withCql(strControl).execute().getResult();
        Rows<Long, String> row = result.getRows(ColumnFamily.newColumnFamily(
                "chatroom",
                LongSerializer.get(),
                StringSerializer.get()));
        for (Row<Long, String> longStringRow : row){
            ColumnList<String> columns = longStringRow.getColumns();
            ownerId = columns.getLongValue("roomownerid", null);
            if(ownerId > 0 ){
                keyspace.prepareCqlStatement().withCql(strUpdate).execute();
            }

        }

    }

    public ChatMessages getMessage(long idMessage, long user, long _idRoom) throws ConnectionException {
        ChatMessages chatMessage = null;
        long guestId = 0;
        long roomownerid = 0;
        long senderid = 0;
        String strMessage = "SELECT * FROM chatmessage WHERE idmessage = " + idMessage;
        String strGuestRoom = "SELECT * FROM guestroom WHERE idroom=" + _idRoom + " AND guestid=" + user;
        String strRoomOwner = " SELECT *  from chatroom WHERE idroom=" + _idRoom + " and roomownerid=" + user;
        CqlStatementResult result = keyspace.prepareCqlStatement().withCql(strMessage).execute().getResult();
        Rows<Long, String> riga = result.getRows(ColumnFamily.newColumnFamily(
                "chatmessage",
                LongSerializer.get(),
                StringSerializer.get()));
        for (Row<Long, String> longStringRow : riga) {
            ColumnList<String> columns = longStringRow.getColumns();
            senderid = columns.getLongValue("senderid", null) ;
            chatMessage = new ChatMessages();
            chatMessage.setMessage(columns.getStringValue("message", null));
            chatMessage.setSenderId(senderid);
            chatMessage.setIdChatRoom(columns.getLongValue("idchatroom", null));
            chatMessage.setDateTime(columns.getLongValue("datetime", null));
            chatMessage.setAttached(columns.getStringValue("attached", null));
            chatMessage.setAttachedType(columns.getStringValue("attachedtype", null));
            chatMessage.setIdMessage(columns.getLongValue("idmessage", null));
            chatMessage.setReadMessage(columns.getBooleanValue("readmessage", null));
            chatMessage.setSender(columns.getStringValue("sender", null));
        }
        CqlStatementResult resultGuest = keyspace.prepareCqlStatement().withCql(strGuestRoom).execute().getResult();
        Rows<Long, String> rowGuest = resultGuest.getRows(ColumnFamily.newColumnFamily(
                "guestroom",
                LongSerializer.get(),
                StringSerializer.get()));
        for (Row<Long, String> longStringRow : rowGuest){
            ColumnList<String> columns = longStringRow.getColumns();
            guestId = columns.getLongValue("guestid", null) ;
        }

        CqlStatementResult resultOwner = keyspace.prepareCqlStatement().withCql(strRoomOwner).execute().getResult();
        Rows<Long, String> rowOwner = resultOwner.getRows(ColumnFamily.newColumnFamily(
                "chatroomroom",
                LongSerializer.get(),
                StringSerializer.get()));
        for (Row<Long, String> longStringRow : rowOwner){
            ColumnList<String> columns = longStringRow.getColumns();
            roomownerid = columns.getLongValue("roomownerid", null) ;
        }



        if ( senderid == user ||   guestId != 0 || roomownerid != 0)
            return chatMessage;
        else
            return null;
    }


    public List<ChatMessages> getMessagesFromRoom(long idChatRoom) throws ConnectionException {
        List<ChatMessages> listOfMessages = new ArrayList<ChatMessages>();
        String sqlStrMessage = "SELECT * FROM chatmessage where idChatRoom = " +  idChatRoom  + "  ORDER BY  DateTime ASC ";

        CqlStatementResult result = keyspace.prepareCqlStatement().withCql(sqlStrMessage).execute().getResult();
        Rows<Long, String> riga = result.getRows(ColumnFamily.newColumnFamily(
                "chatmessage",
                LongSerializer.get(),
                StringSerializer.get()));
        for (Row<Long, String> longStringRow : riga) {
            ColumnList<String> columns = longStringRow.getColumns();
            ChatMessages chatMessage = new ChatMessages();
            chatMessage.setMessage(columns.getStringValue("message", null));
            chatMessage.setSenderId(columns.getLongValue("senderid", null));
            chatMessage.setIdChatRoom(columns.getLongValue("idchatroom", null));
            chatMessage.setDateTime(columns.getLongValue("datetime", null));
            chatMessage.setAttached(columns.getStringValue("attached", null));
            chatMessage.setAttachedType(columns.getStringValue("attachedtype", null));
            chatMessage.setIdMessage(columns.getLongValue("idmessage", null));
            chatMessage.setReadMessage(columns.getBooleanValue("readmessage", null));
            chatMessage.setSender(columns.getStringValue("sender", null));
            listOfMessages.add(chatMessage);
        }

        return listOfMessages;
    }


    public long[] insertMessage(long idRoom, long senderId, String sender,  String message, String attached, String attachedType)  throws ConnectionException{
        long[] arrLong = new long[2];
        String strtTmp = "";
        IncrementIndexMessage incrementIndexMessage = new IncrementIndexMessage(keyspace);
        long idChatMessage = incrementIndexMessage.incrementId();
        strtTmp = " ( " + idChatMessage + ", ";
        strtTmp = strtTmp +  senderId + ", ";
        strtTmp = strtTmp + new Date().getTime();
        strtTmp = strtTmp + ",'" + sender + "',";
        strtTmp = strtTmp + "'" + message + "',";
        strtTmp = strtTmp + "'" + attached + "',  '" + attachedType + "', false ," + idRoom  +   ")";
        String strInsert = " INSERT INTO chatmessage ( idMessage,  SenderId, DateTime, Sender,  Message, Attached, attachedType,  readMessage, idChatRoom) VALUES  ";
        strInsert = strInsert + strtTmp;
        keyspace.prepareCqlStatement().withCql(strInsert).execute();

        arrLong[0] = idChatMessage;
        arrLong[1] = idRoom;

        return arrLong;
    }


    public List getRoomFromOwner(long idUser)  throws ConnectionException {
        List<ChatRoom> chatRooms = new ArrayList<ChatRoom>();
        List<GuestRoom> guestRooms = new ArrayList<GuestRoom>();
        ChatRoom chatRoom = null;
        GuestRoom guestRoom = null;
        String sqlStr = "SELECT * FROM chatroom WHERE roomOwnerId = " + idUser + " AND active=true ALLOW FILTERING";
        String sqlStrGuest = "SELECT * FROM guestRoom WHERE idRoom = ";
        List<Long> guestIdRooms = new ArrayList<Long>();

        CqlStatementResult result = keyspace.prepareCqlStatement().withCql(sqlStr).execute().getResult();
        Rows<Long, String> riga = result.getRows(ColumnFamily.newColumnFamily(
                "chatroom",
                LongSerializer.get(),
                StringSerializer.get()));
        ColumnFamily<Long, String> guest_room = ColumnFamily.newColumnFamily(
                "guestRoom",
                LongSerializer.get(),
                StringSerializer.get());
        UserManager userManager = new LiferayUserManager();
        GCubeUser gCubeUser = null;
        OperationResult<CqlResult<Long, String>> resultGuest;
        for (Row<Long, String> longStringRow : riga) {
            chatRoom = new ChatRoom();
            ColumnList<String> columns = longStringRow.getColumns();
            chatRoom.setIdRoom(columns.getLongValue("idroom", null));
            chatRoom.setRoomOwnerId(columns.getLongValue("roomownerid", null));
            chatRoom.setRoomOwner(columns.getStringValue("roomowner", null));
            chatRoom.setRoomOwnerFullName(columns.getStringValue("roomownerfullname", null));
            chatRoom.setNameRoom(columns.getStringValue("nameroom", null));

            resultGuest = keyspace.prepareQuery(guest_room).withCql(sqlStrGuest + chatRoom.getIdRoom()).execute();
            for (Row<Long, String> rowGuest : resultGuest.getResult().getRows()) {
                ColumnList<String> columnsGuest = rowGuest.getColumns();
                guestRoom = new GuestRoom();
                guestRoom.setGuestId(columnsGuest.getLongValue("guestid", null));
                guestRoom.setIdRoom(columnsGuest.getLongValue("idroom", null));
                guestRoom.setGuestName(columnsGuest.getStringValue("guestname", null));
                guestRoom.setGuestFullName(columnsGuest.getStringValue("guestfullname", null));
                try {
                    gCubeUser = userManager.getUserById(guestRoom.getGuestId());
                } catch (UserManagementSystemException e) {
                    e.printStackTrace();
                } catch (UserRetrievalFault userRetrievalFault) {
                    userRetrievalFault.printStackTrace();
                }
                if(gCubeUser != null)
                    guestRoom.setUrlAvatar(gCubeUser.getUserAvatarURL());
                else
                    guestRoom.setUrlAvatar("/image/user_male_portrait");


                guestRooms.add(guestRoom);
                chatRoom.setGuestList(guestRooms);
            }
            chatRooms.add(chatRoom);


        }

//        for (ChatRoom room : chatRooms) {
//            System.out.println("Romm " + room.getNameRoom());
//            System.out.println("Owner Fullname  " + room.getRoomOwnerFullName());
//            System.out.println("Owner ScreenName " + room.getRoomOwner());
//            List<GuestRoom>  lista = room.getGuestList();
//            for (GuestRoom guestRoom1 : lista) {
//                System.out.println( "Guest FullName " + guestRoom1.getGuestFullName());
//                System.out.println("IDROOM " + guestRoom1.getIdRoom());
//            }
//        }

        return chatRooms;
    }

    public List<ChatRoom> getRoomsFromGuest(long idUser) throws ConnectionException {
        List<ChatRoom> chatRooms = new ArrayList<ChatRoom>();
        List<GuestRoom> guestRooms = new ArrayList<GuestRoom>();
        List<Long> guestIdRooms = new ArrayList<Long>();

     //   ChatRoom chatRoom = null;
        GuestRoom guestRoom = null;
        String sqlIdRoom = "SELECT idRoom FROM guestroom WHERE guestId = " + idUser;
        String sqlStr = "SELECT * FROM chatroom WHERE idRoom = ";
        String sqlStrGuest = "SELECT * FROM guestRoom WHERE idRoom = ";
        CqlStatementResult result = keyspace.prepareCqlStatement().withCql(sqlIdRoom).execute().getResult();
        Rows<Long, String> riga = result.getRows(ColumnFamily.newColumnFamily(
                "guestroom",
                LongSerializer.get(),
                StringSerializer.get()));
        for (Row<Long, String> longStringRow : riga) {
            ColumnList<String> columns = longStringRow.getColumns();
            guestIdRooms.add(columns.getLongValue("idroom", null));
        }

        ColumnFamily<Long, String> chat_room = ColumnFamily.newColumnFamily(
                "chatroom",
                LongSerializer.get(),
                StringSerializer.get());

        ColumnFamily<Long, String> guest_room = ColumnFamily.newColumnFamily(
                "guestRoom",
                LongSerializer.get(),
                StringSerializer.get());

        UserManager userManager = new LiferayUserManager();

        OperationResult<CqlResult<Long, String>> result1;
        OperationResult<CqlResult<Long, String>> resultGuest;
        GCubeUser gCubeUser = null;
        for (Long guestIdRoom : guestIdRooms) {
            result1 = keyspace.prepareQuery(chat_room).withCql(sqlStr + guestIdRoom).execute();
            ChatRoom chatRoom1 = new ChatRoom();
            for (Row<Long, String> row : result1.getResult().getRows()) {
                ColumnList<String> columns = row.getColumns();
                chatRoom1.setIdRoom(columns.getLongValue("idroom", null));
                chatRoom1.setRoomOwnerId(columns.getLongValue("roomownerid", null));
                chatRoom1.setRoomOwner(columns.getStringValue("roomowner", null));
                chatRoom1.setRoomOwnerFullName(columns.getStringValue("roomownerfullname", null));
                chatRoom1.setNameRoom(columns.getStringValue("nameroom", null));
                try {
                    gCubeUser = userManager.getUserById(chatRoom1.getRoomOwnerId());
                }catch (Exception e){
                    e.printStackTrace();
                }
                chatRoom1.setOwnerUrlAvatar(gCubeUser.getUserAvatarURL());

                resultGuest = keyspace.prepareQuery(guest_room).withCql(sqlStrGuest + guestIdRoom).execute();
                for (Row<Long, String> rowGuest : resultGuest.getResult().getRows()) {
                    ColumnList<String> columnsGuest = rowGuest.getColumns();
                    guestRoom = new GuestRoom();
                    guestRoom.setGuestId(columnsGuest.getLongValue("guestid", null));
                    guestRoom.setIdRoom(columnsGuest.getLongValue("idroom", null));
                    guestRoom.setGuestName(columnsGuest.getStringValue("guestname", null));
                    guestRoom.setGuestFullName(columnsGuest.getStringValue("guestfullname", null));
                    try {
                        gCubeUser = userManager.getUserById(guestRoom.getGuestId());
                    } catch (UserManagementSystemException e) {
                        e.printStackTrace();
                    } catch (UserRetrievalFault userRetrievalFault) {
                        userRetrievalFault.printStackTrace();
                    }
                    if(gCubeUser != null)
                        guestRoom.setUrlAvatar(gCubeUser.getUserAvatarURL());
                    else
                        guestRoom.setUrlAvatar("/image/user_male_portrait");



                    guestRooms.add(guestRoom);
                    chatRoom1.setGuestList(guestRooms);
                }
                chatRooms.add(chatRoom1);
            }
        }

//        for (GuestRoom room : guestRooms) {
//            System.out.println("Romm id" + room.getIdRoom());
//            System.out.println("Guest Fullname  " + room.getGuestFullName());
//            System.out.println("Guest ScreenName " + room.getGuestName());
//
//        }


        return chatRooms;
    }


    public long createRoom(long idUser, ChatRoom chatRoom) throws ConnectionException {
        long ownerId = chatRoom.getRoomOwnerId();
        String ownerName = chatRoom.getRoomOwner();
        String ownerFullName = chatRoom.getRoomOwnerFullName();
        String roomName = chatRoom.getNameRoom();
        IncrementIndexMessage incrementIndexMessage = new IncrementIndexMessage(keyspace);
        long idRoom = incrementIndexMessage.incrementRoom();
        keyspace.prepareCqlStatement().withCql("INSERT INTO chatroom " +
                " (idRoom, roomOwner, roomOwnerFullName, roomOwnerId, nameRoom, active ) " +
                " VALUES (" +
                +idRoom + " , " +
                "'" + ownerName + "'," +
                "'" + ownerFullName + "'," +
                +ownerId + "," +
                "'" + roomName + "'," +
                " true " +
                ");").execute();
        List<GuestRoom> guestList = chatRoom.getGuestList();
        for (GuestRoom guestRoom : guestList) {
            keyspace.prepareCqlStatement().withCql("INSERT INTO guestRoom (idRoom, guestId, guestName, guestFullName ) VALUES  " +
                    "(" +
                    + idRoom + " , " +
                    "" + guestRoom.getGuestId() + "," +
                    "'" + guestRoom.getGuestName() + "'," +
                    "'" + guestRoom.getGuestFullName() + "'" +
                    ");").execute();
        }
        return idRoom;
    }


    public List<ChatMessages> searchMessages(String string , long idChatroom)  throws ConnectionException {
        List<ChatMessages> listOfMessages = new ArrayList<ChatMessages>();
        char ch = 34;
        String sqlStrMessage = "";
        string = string.trim();
        String tmpString = ch + string + ch;
        if( string.contains(" "))
            sqlStrMessage = " SELECT * FROM chatmessage WHERE lucene='{query :{type:\"phrase\",field:\"message\",value:" + tmpString + ",slop:1 } }' AND idchatroom = " + idChatroom ;
        else
            sqlStrMessage = " SELECT * FROM chatmessage WHERE lucene='{query :{type:\"prefix\",field:\"message\",value:" + tmpString + ",slop:1 } }' AND idchatroom = " + idChatroom ;

        System.out.println("sqlStrMessage " + sqlStrMessage);


        CqlStatementResult result = keyspace.prepareCqlStatement().withCql(sqlStrMessage).execute().getResult();
        Rows<Long, String> riga = result.getRows(ColumnFamily.newColumnFamily(
                "chatmessage",
                LongSerializer.get(),
                StringSerializer.get()));
        for (Row<Long, String> longStringRow : riga) {
            ColumnList<String> columns = longStringRow.getColumns();
            ChatMessages chatMessage = new ChatMessages();
            chatMessage.setMessage(columns.getStringValue("message", null));
            chatMessage.setSenderId(columns.getLongValue("senderid", null));
            chatMessage.setIdChatRoom(columns.getLongValue("idchatroom", null));
            chatMessage.setDateTime(columns.getLongValue("datetime", null));
            chatMessage.setAttached(columns.getStringValue("attached", null));
            chatMessage.setAttachedType(columns.getStringValue("attachedtype", null));
            chatMessage.setIdMessage(columns.getLongValue("idmessage", null));
            chatMessage.setReadMessage(columns.getBooleanValue("readmessage", null));
            chatMessage.setSender(columns.getStringValue("sender", null));
            listOfMessages.add(chatMessage);
        }

        return listOfMessages;
    }


    public List<UsersChat> getUserFromRoom(long idRoom) throws ConnectionException{
        List<UsersChat> usersChats = new ArrayList<UsersChat>();
        UsersChat user;

        String strChatRoom = "SELECT  * FROM chatroom WHERE idroom=" + idRoom ;
        String sqlStrGuest = "SELECT * FROM guestRoom WHERE idRoom = "  + idRoom ;

        CqlStatementResult result = keyspace.prepareCqlStatement().withCql(strChatRoom).execute().getResult();
        Rows<Long, String> riga = result.getRows(ColumnFamily.newColumnFamily(
                "chatroom",
                LongSerializer.get(),
                StringSerializer.get()));
        for (Row<Long, String> longStringRow : riga) {
            ColumnList<String> columns = longStringRow.getColumns();
            user = new UsersChat();
            user.setId(columns.getLongValue("roomownerid", null));
            user.setUserName(columns.getStringValue("roomowner", null));
            user.setFullName(columns.getStringValue("roomownerfullname", null));
            user.setUrlAvatar("");
            usersChats.add(user);
        }

        CqlStatementResult result1 = keyspace.prepareCqlStatement().withCql(sqlStrGuest).execute().getResult();
        Rows<Long, String> riga1 = result1.getRows(ColumnFamily.newColumnFamily(
                "guestRoom",
                LongSerializer.get(),
                StringSerializer.get()));
        for (Row<Long, String> longStringRow : riga1) {
            ColumnList<String> columns1 = longStringRow.getColumns();
            user = new UsersChat();
            user.setId(columns1.getLongValue("guestid", null));
            user.setUserName(columns1.getStringValue("guestname", null));
            user.setFullName(columns1.getStringValue("guestfullname", null));
            user.setUrlAvatar("");
            usersChats.add(user);
        }

        return usersChats;
    }

/*
        CqlStatementResult result =   keyspace.prepareCqlStatement().withCql("SELECT idchatroom FROM indexchatmessage;").execute().getResult();


        //result.asCount()
        //result.getSchema()




        Rows<Long,String> riga = result.getRows(ColumnFamily.newColumnFamily(
                "chatroom",
                LongSerializer.get(),
                StringSerializer.get()));

        for (Row<Long, String> longStringRow : riga) {
            ColumnList<String> columns = longStringRow.getColumns();
            idRoom = columns.getLongValue("idroom", null);
        }
*/


}
