package it.eng.edison.messages.server.util;

import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.connectionpool.NodeDiscoveryType;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.astyanax.connectionpool.impl.CountingConnectionPoolMonitor;
import com.netflix.astyanax.impl.AstyanaxConfigurationImpl;
import com.netflix.astyanax.thrift.ThriftFamilyFactory;

import  org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;


import org.gcube.common.portal.PortalContext;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

/**
 * Created by Administrator on 22/07/2016.
 */
public class ConnectCassandra {

    private AstyanaxContext<Keyspace> context;
    private Keyspace keyspace;
    private String dbserver;
    private String dbPort;
    private String clusterName;
    private String keySpaceName;


    private static final String HOST_PROPERTY = "host";
    private static final String HOST_PORT_PROPERTY = "port";
    private static final String CLUSTER_NAME_PROPERTY = "cluster";
    private static final String KEY_SPACE_NAME_PROPERTY = "keyspace";
    /**
     * other constants
     */
    private final static String RUNTIME_RESOURCE_NAME = "SocialPortalDataStore";
    private final static String PLATFORM_NAME = "Cassandra";


    private static final String DEFAULT_CONFIGURATION = "/org/gcube/portal/databook/server/resources/databook.properties";

    public ConnectCassandra() {
        Properties properties = new Properties();
//        List<ServiceEndpoint> serviceEndPoint = new ArrayList<ServiceEndpoint>();
//
//
//
//        DBCassandraAstyanaxImpl dbCassandraAstyanax = new DBCassandraAstyanaxImpl();
//


        try {
            ClassLoader cl = this.getClass().getClassLoader();
            properties.load(cl.getResourceAsStream("messaging.properties"));
            dbserver = properties.getProperty("DB_Server");
            dbPort = properties.getProperty("DB_Port");
            clusterName = properties.getProperty("ClusterName");
            keySpaceName = properties.getProperty("KeySpaceName");


            System.out.println("dbserver : " + dbserver );

        //    serviceEndPoint = getConfigurationFromIS ("gcube");


        }catch (Exception e){
            e.printStackTrace();
        }

//
//          for (ServiceEndpoint serviceEndpoint : serviceEndPoint) {
//
//            System.out.println("--- serviceEndPoint "+serviceEndpoint.profile().runtime().hostedOn());
//
//              serviceEndpoint.profile().
//
//
//        }
        

    }


    public Keyspace getKeyspace(){
        context = new AstyanaxContext.Builder()
                .forCluster(clusterName)
                .forKeyspace(keySpaceName)
                .withAstyanaxConfiguration(new AstyanaxConfigurationImpl()
                        .setCqlVersion("3.3.1")
                        .setTargetCassandraVersion("2.2.5")
                        .setDiscoveryType(NodeDiscoveryType.RING_DESCRIBE)
                )
                .withConnectionPoolConfiguration(new ConnectionPoolConfigurationImpl("MyConnectionPool")
                        .setPort(Integer.parseInt(dbPort))
                        .setMaxConnsPerHost(2)
                        .setSeeds( dbserver + ":" + dbPort)
                        .setConnectTimeout(2000)
                )
                .withConnectionPoolMonitor(new CountingConnectionPoolMonitor())
                .buildKeyspace(ThriftFamilyFactory.getInstance());
        context.start();

        keyspace = context.getClient();

        return keyspace;
    }


    private List<ServiceEndpoint> getConfigurationFromIS(String infrastructureName) throws Exception  {

        PortalContext context = null;//PortalContext.getConfiguration();
        String scope = "/";
        if(infrastructureName != null && !infrastructureName.isEmpty())
            scope += infrastructureName;
        else{
            scope += context.getInfrastructureName();
            System.out.println("context.getInfrastructureName()"+context.getInfrastructureName());
        }
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(scope);
        SimpleQuery query = queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq '"+ RUNTIME_RESOURCE_NAME +"'");
        query.addCondition("$resource/Profile/Platform/Name/text() eq '"+ PLATFORM_NAME +"'");
        DiscoveryClient<ServiceEndpoint> client = clientFor(ServiceEndpoint.class);
        List<ServiceEndpoint> toReturn = client.submit(query);
        ScopeProvider.instance.set(currScope);
        return toReturn;
    }

}
