package it.eng.edison.messages.server.util;

import java.io.*;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;




/**
 * Created by Administrator on 16/06/2016.
 */
public class EdisonMessagesUploadServlet extends HttpServlet {

    private String pathImage = null;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        pathImage = config.getInitParameter("pathImage");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response)  throws ServletException, IOException {

        FileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload(factory);

        try{

            List items = upload.parseRequest(request);
            Iterator iter = items.iterator();

            while (iter.hasNext()) {
                FileItem item = (FileItem) iter.next();
                if (!item.isFormField()) {
                    String fieldName = item.getFieldName();
                    String fileName = item.getName();

                    if (fileName != null) {
                        fileName = FilenameUtils.getName(fileName);
                    }
                    String contentType = item.getContentType();
                    boolean isInMemory = item.isInMemory();
                    long sizeInBytes = item.getSize();
                    byte[] data = item.get();
                    fileName = pathImage + fileName;
                      FileOutputStream fileOutSt = new FileOutputStream(fileName);
                    fileOutSt.write(data);
                    fileOutSt.close();
                     InputStream is = new ByteArrayInputStream(contentType.getBytes()) ;
                    OutputStream out = response.getOutputStream();

                    byte[] buffer = new byte[1024];
                    int len;
                    while ((len = is.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    is.close();
                    out.flush();
                    out.close();
                }
            }
        }catch(Exception e){
            System.out.println("File Uploading Failed!" + e.getMessage());
            e.printStackTrace();
        }

    }

}
