/*
 * Decompiled with CFR 0.152.
 */
package it.eng.edison.usersurvey_portlet.server.dao;

import it.eng.edison.usersurvey_portlet.client.model.SurveyModel;
import it.eng.edison.usersurvey_portlet.client.model.SurveyQuestionModel;
import it.eng.edison.usersurvey_portlet.server.dao.exceptions.NonexistentEntityException;
import it.eng.edison.usersurvey_portlet.server.entity.Survey;
import it.eng.edison.usersurvey_portlet.server.entity.Surveyquestion;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class SurveyquestionJpaController
implements Serializable {
    private EntityManagerFactory emf = null;

    public SurveyquestionJpaController(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public EntityManager getEntityManager() {
        return this.emf.createEntityManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Surveyquestion surveyquestion) {
        try (EntityManager em = null;){
            em = this.getEntityManager();
            em.getTransaction().begin();
            Survey idSurvey = surveyquestion.getIdSurvey();
            if (idSurvey != null) {
                idSurvey = (Survey)em.getReference(idSurvey.getClass(), (Object)idSurvey.getId());
                surveyquestion.setIdSurvey(idSurvey);
            }
            em.persist((Object)surveyquestion);
            if (idSurvey != null) {
                idSurvey.getSurveyquestionCollection().add(surveyquestion);
                idSurvey = (Survey)em.merge((Object)idSurvey);
            }
            em.getTransaction().commit();
        }
    }

    public void edit(Surveyquestion surveyquestion) throws NonexistentEntityException, Exception {
        try (EntityManager em = null;){
            em = this.getEntityManager();
            em.getTransaction().begin();
            Surveyquestion persistentSurveyquestion = (Surveyquestion)em.find(Surveyquestion.class, (Object)surveyquestion.getId());
            Survey idSurveyOld = persistentSurveyquestion.getIdSurvey();
            Survey idSurveyNew = surveyquestion.getIdSurvey();
            if (idSurveyNew != null) {
                idSurveyNew = (Survey)em.getReference(idSurveyNew.getClass(), (Object)idSurveyNew.getId());
                surveyquestion.setIdSurvey(idSurveyNew);
            }
            surveyquestion = (Surveyquestion)em.merge((Object)surveyquestion);
            if (idSurveyOld != null && !idSurveyOld.equals((Object)idSurveyNew)) {
                idSurveyOld.getSurveyquestionCollection().remove(surveyquestion);
                idSurveyOld = (Survey)em.merge((Object)idSurveyOld);
            }
            if (idSurveyNew != null && !idSurveyNew.equals((Object)idSurveyOld)) {
                idSurveyNew.getSurveyquestionCollection().add(surveyquestion);
                idSurveyNew = (Survey)em.merge((Object)idSurveyNew);
            }
            em.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Integer id) throws NonexistentEntityException {
        try (EntityManager em = null;){
            Surveyquestion surveyquestion;
            em = this.getEntityManager();
            em.getTransaction().begin();
            try {
                surveyquestion = (Surveyquestion)em.getReference(Surveyquestion.class, (Object)id);
                surveyquestion.getId();
            }
            catch (EntityNotFoundException enfe) {
                throw new NonexistentEntityException("The surveyquestion with id " + id + " no longer exists.", (Throwable)enfe);
            }
            Survey idSurvey = surveyquestion.getIdSurvey();
            if (idSurvey != null) {
                idSurvey.getSurveyquestionCollection().remove(surveyquestion);
                idSurvey = (Survey)em.merge((Object)idSurvey);
            }
            em.remove((Object)surveyquestion);
            em.getTransaction().commit();
        }
    }

    public List<Surveyquestion> findSurveyquestionEntities() {
        return this.findSurveyquestionEntities(true, -1, -1);
    }

    public List<Surveyquestion> findSurveyquestionEntities(int maxResults, int firstResult) {
        return this.findSurveyquestionEntities(false, maxResults, firstResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Surveyquestion> findSurveyquestionEntities(boolean all, int maxResults, int firstResult) {
        try (EntityManager em = this.getEntityManager();){
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery();
            cq.select((Selection)cq.from(Surveyquestion.class));
            TypedQuery q = em.createQuery(cq);
            if (!all) {
                q.setMaxResults(maxResults);
                q.setFirstResult(firstResult);
            }
            List list = q.getResultList();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surveyquestion findSurveyquestion(Integer id) {
        EntityManager em = this.getEntityManager();
        try {
            Surveyquestion surveyquestion = (Surveyquestion)em.find(Surveyquestion.class, (Object)id);
            return surveyquestion;
        }
        finally {
            em.close();
            em = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSurveyquestionCount() {
        EntityManager em = this.getEntityManager();
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery();
            Root rt = cq.from(Surveyquestion.class);
            cq.select((Selection)em.getCriteriaBuilder().count((Expression)rt));
            TypedQuery q = em.createQuery(cq);
            int n = ((Long)q.getSingleResult()).intValue();
            return n;
        }
        finally {
            em.close();
            em = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteQuestions(int idSurveyQuestion) {
        int deletedCount = 0;
        Query query = null;
        EntityManager em = this.getEntityManager();
        try {
            em.getTransaction().begin();
            query = em.createQuery("DELETE FROM Surveyquestion where id_survey = :idSurveyQuestion");
            deletedCount = query.setParameter("idSurveyQuestion", (Object)idSurveyQuestion).executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            em.getTransaction().commit();
            em.close();
            em = null;
        }
        return deletedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSurvey(SurveyModel surveyModel) {
        Query query = null;
        EntityManager em = this.getEntityManager();
        try {
            em.getTransaction().begin();
            query = em.createQuery("UPDATE Survey s SET s.titlesurvey = :titlesurvey, s.idusercreator = :idusercreator, s.datesurvay = :datesurvay, s.expireddatesurvay = :expireddatesurvay, s.isanonymous = :isanonymous WHERE s.id = :id");
            query.setParameter("id", (Object)surveyModel.getIdsurvey());
            query.setParameter("titlesurvey", (Object)surveyModel.getTitlesurvey());
            query.setParameter("idusercreator", (Object)surveyModel.getIdUserCreator());
            query.setParameter("datesurvay", (Object)surveyModel.getDateSurvay());
            query.setParameter("expireddatesurvay", (Object)surveyModel.getExpiredDateSurvay());
            query.setParameter("isanonymous", (Object)surveyModel.getIsAnonymous());
            int queryExecuted = query.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            em.getTransaction().commit();
            em.close();
            em = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteImageFilenameFromDB(int idSurvey) {
        Query query = null;
        EntityManager em = this.getEntityManager();
        try {
            em.getTransaction().begin();
            query = em.createQuery("UPDATE Surveyquestion s SET s.imagefilename = :imagefilename WHERE s.idSurvey.id = :idSurvey");
            query.setParameter("idSurvey", (Object)idSurvey);
            query.setParameter("imagefilename", null);
            int queryExecuted = query.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            em.getTransaction().commit();
            em.close();
            em = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertMultipleChoice(Survey survey, SurveyQuestionModel surveyQuestionModel) {
        List multipleChoiceListTemp = surveyQuestionModel.getMultipleChoiceList();
        Query query = null;
        EntityManager em = this.getEntityManager();
        try {
            em.getTransaction().begin();
            for (int i = 0; i < multipleChoiceListTemp.size(); ++i) {
                query = em.createNativeQuery("INSERT INTO Surveyquestion(id_survey, numberquestion, ismandatory, questiontype, question, answer1) VALUES(?,?,?,?,?,?)");
                query.setParameter(1, (Object)survey.getId());
                query.setParameter(2, (Object)surveyQuestionModel.getNumberquestion());
                query.setParameter(3, (Object)surveyQuestionModel.getIsmandatory());
                query.setParameter(4, (Object)surveyQuestionModel.getQuestiontype());
                query.setParameter(5, (Object)surveyQuestionModel.getQuestion());
                query.setParameter(6, multipleChoiceListTemp.get(i));
                int queryExecuted = query.executeUpdate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            em.getTransaction().commit();
            em.close();
            em = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Surveyquestion> findSurveyQuestionByIdSurvey(int idSurvey) {
        Query query = null;
        List surveyQuestionList = null;
        EntityManager em = this.getEntityManager();
        try {
            em.getTransaction().begin();
            query = em.createQuery("SELECT s FROM Surveyquestion s WHERE s.idSurvey.id = :idSurvey ORDER BY s.numberquestion");
            query.setParameter("idSurvey", (Object)idSurvey);
            surveyQuestionList = query.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            em.getTransaction().commit();
            em.close();
            em = null;
        }
        return surveyQuestionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long findFolderIdByIdSurvey(int idSurvey) {
        Query query = null;
        long folderId = 0L;
        EntityManager em = this.getEntityManager();
        try {
            em.getTransaction().begin();
            query = em.createQuery("SELECT s.folderidimage FROM Surveyquestion s WHERE s.idSurvey.id = :idSurvey");
            query.setParameter("idSurvey", (Object)idSurvey);
            folderId = (Long)query.getSingleResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            em.getTransaction().commit();
            em.close();
            em = null;
        }
        return folderId;
    }
}

