/*
 * Decompiled with CFR 0.152.
 */
package smallgears.api;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Apikit {
    public static <T> Stream<T> streamof(Iterable<T> vals) {
        return Apikit.streamof(vals, false);
    }

    public static <T> Stream<T> streamof(Iterable<T> vals, boolean parallel) {
        return StreamSupport.stream(vals.spliterator(), parallel);
    }

    public static String join(Stream<String> vals) {
        return vals.filter(s -> s != null).collect(Collectors.joining());
    }

    public static RuntimeException unchecked(Throwable t) {
        return t instanceof RuntimeException ? (RuntimeException)RuntimeException.class.cast(t) : new RuntimeException(t);
    }

    public static RuntimeException unchecked(String msg, Throwable t) {
        msg = msg + " (see cause) ";
        return t instanceof IllegalArgumentException ? new IllegalArgumentException(msg, t) : (t instanceof IllegalStateException ? new IllegalStateException(msg, t) : new RuntimeException(msg, t));
    }

    public static void rethrow(String msg, Throwable t) throws RuntimeException {
        throw Apikit.unchecked(msg, t);
    }

    public static void rethrow(Throwable t) throws RuntimeException {
        throw Apikit.unchecked(t);
    }

    private Apikit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

