/*
 * Decompiled with CFR 0.152.
 */
package smallgears.api.tabular;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.UnaryOperator;
import smallgears.api.tabular.Column;
import smallgears.api.tabular.Row;
import smallgears.api.tabular.impl.SimpleTable;
import smallgears.api.tabular.impl.StreamedTable;
import smallgears.api.tabular.utils.Streamable;

public interface Table
extends Streamable<Row> {
    public List<Column> columns();

    public SimpleTable materialise();

    public boolean materialised();

    default public Table with(final UnaryOperator<Row> transform) {
        final Iterator current = this.iterator();
        return new StreamedTable(new ArrayList<Column>(this.columns()), new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return current.hasNext();
            }

            @Override
            public Row next() {
                return (Row)transform.apply(current.next());
            }
        });
    }

    default public Table copy() {
        return this.with(Row::new);
    }
}

