/*
 * Decompiled with CFR 0.152.
 */
package smallgears.api.tabular;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import smallgears.api.tabular.Column;
import smallgears.api.tabular.Row;
import smallgears.api.tabular.dsl.Tables;
import smallgears.api.tabular.impl.SimpleTable;
import smallgears.api.tabular.impl.StreamedTable;
import smallgears.api.tabular.utils.Streamable;

public interface Table
extends Streamable<Row> {
    public List<Column> columns();

    public SimpleTable materialise();

    public boolean materialised();

    default public Table with(final UnaryOperator<Row> transform) {
        final Iterator current = this.iterator();
        return new StreamedTable(new ArrayList<Column>(this.columns()), new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return current.hasNext();
            }

            @Override
            public Row next() {
                return (Row)transform.apply(current.next());
            }
        });
    }

    default public Table unfoldWith(Function<Row, Stream<Row>> transform) {
        return this.parallelStream().flatMap(row -> (Stream)transform.apply((Row)row)).collect(Tables.toTable());
    }

    default public Table copy() {
        return this.with(Row::new);
    }

    default public void show(String ... cols) {
        this.print(System.out, cols);
    }

    default public void print(@NonNull PrintStream out, String ... cols) {
        if (out == null) {
            throw new IllegalArgumentException("out is null");
        }
        if (cols == null) {
            throw new IllegalArgumentException("cols is null");
        }
        int count = 1;
        for (Row row : this) {
            out.println(String.format("%s: %s", cols.length == 0 ? row : Integer.valueOf(count), Stream.of(cols).map(col -> row.getOr((String)col, "<missing>")).collect(Collectors.joining())));
            ++count;
        }
    }
}

