/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository.impl;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smallgears.api.Apikit;
import smallgears.virtualrepository.Asset;
import smallgears.virtualrepository.Repository;
import smallgears.virtualrepository.VirtualRepository;
import smallgears.virtualrepository.common.Constants;
import smallgears.virtualrepository.impl.DefaultVirtualRepository;
import smallgears.virtualrepository.spi.VirtualReader;

public class RetrievalCompanion {
    private static final Logger log = LoggerFactory.getLogger((String)"virtual-repository");
    @NonNull
    DefaultVirtualRepository vr;

    VirtualRepository.ContentCheckClause canRetrieve(Asset asset) {
        return api -> this.readerFor(asset, api).isPresent();
    }

    VirtualRepository.RetrieveAsClause retrieve(final @NonNull Asset asset) {
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        return new VirtualRepository.RetrieveAsClause(){

            @Override
            public <A> VirtualRepository.RetrieveModeClause<A> as(final Class<A> api) {
                return new VirtualRepository.RetrieveModeClause<A>(){
                    Duration timeout = Constants.default_retrieval_timeout;

                    @Override
                    public VirtualRepository.RetrieveModeClause<A> timeout(Duration to) {
                        this.timeout = to;
                        return this;
                    }

                    @Override
                    public A blocking() {
                        Future future = RetrievalCompanion.this.retrieve(asset, api);
                        VirtualRepository.RetrievalObserver dummyObserver = new VirtualRepository.RetrievalObserver<A>(){};
                        return this._blocking(future, dummyObserver);
                    }

                    @Override
                    public Future<A> withoutBlocking() {
                        return RetrievalCompanion.this.retrieve(asset, api);
                    }

                    @Override
                    public void notifying(VirtualRepository.RetrievalObserver<A> observer) {
                        Future future = RetrievalCompanion.this.retrieve(asset, api);
                        RetrievalCompanion.this.vr.executor().submit(() -> this._blocking(future, observer));
                    }

                    private A _blocking(Future<A> future, VirtualRepository.RetrievalObserver<A> observer) {
                        try {
                            Object result = future.get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
                            observer.onSuccess(result);
                            return result;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            observer.onError(e);
                            throw Apikit.unchecked((Throwable)e);
                        }
                        catch (ExecutionException | TimeoutException e) {
                            Throwable t = e instanceof ExecutionException ? e.getCause() : e;
                            observer.onError(t);
                            throw Apikit.unchecked((String)String.format("cannot retrieve content for asset %s from repository service %s", asset.name(), asset.repository().name()), (Throwable)t);
                        }
                    }
                };
            }
        };
    }

    private <A> Future<A> retrieve(final Asset asset, Class<A> api) {
        Repository repo = asset.repository();
        final VirtualReader<A> reader = this.readerFor(asset, api).orElseThrow(() -> new IllegalStateException(String.format("cannot retrieve asset %s from %s: no reader for api %s", asset.name(), repo, api)));
        Callable task = new Callable<A>(){

            @Override
            public A call() throws Exception {
                log.info("retrieving content of asset {}", (Object)asset.name());
                long time = System.currentTimeMillis();
                Object result = reader.retrieve(asset);
                log.info("retrieved content of asset {} in {} ms.", (Object)asset.name(), (Object)(System.currentTimeMillis() - time));
                return result;
            }
        };
        return this.vr.executor().submit(task);
    }

    private <A> Optional<VirtualReader<A>> readerFor(Asset asset, Class<A> api) {
        if (asset.repository() == null) {
            throw new IllegalArgumentException(String.format("asset %s is not bound to a repository, hence cannot be retrieved.", asset.name()));
        }
        List<VirtualReader<?>> basereaders = asset.repository().proxy().readers();
        return this.vr.transforms().inferReader(basereaders, asset.type(), api);
    }

    @ConstructorProperties(value={"vr"})
    public RetrievalCompanion(@NonNull DefaultVirtualRepository vr) {
        if (vr == null) {
            throw new IllegalArgumentException("vr is null");
        }
        this.vr = vr;
    }
}

