/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smallgears.api.Apikit;
import smallgears.virtualrepository.Asset;
import smallgears.virtualrepository.AssetType;
import smallgears.virtualrepository.common.Utils;
import smallgears.virtualrepository.spi.Accessor;
import smallgears.virtualrepository.spi.ReaderAdapter;
import smallgears.virtualrepository.spi.Transform;
import smallgears.virtualrepository.spi.VirtualReader;
import smallgears.virtualrepository.spi.VirtualWriter;
import smallgears.virtualrepository.spi.WriterAdapter;

public class Transforms
implements Iterable<Transform<?, ?>> {
    private static final Logger log = LoggerFactory.getLogger((String)"virtual-repository");
    List<Transform<?, ?>> transforms = new ArrayList();

    public Transforms(@NonNull Iterable<Transform<?, ?>> transforms) {
        if (transforms == null) {
            throw new IllegalArgumentException("transforms is null");
        }
        this.add(transforms);
    }

    public Transforms(Transform<?, ?> ... transforms) {
        this(Arrays.asList(transforms));
        if (transforms == null) {
            throw new IllegalArgumentException("transforms is null");
        }
    }

    @Override
    public Iterator<Transform<?, ?>> iterator() {
        return this.transforms.iterator();
    }

    public Transforms add(Transform<?, ?> ... transforms) {
        if (transforms == null) {
            throw new IllegalArgumentException("transforms is null");
        }
        return this.add(Arrays.asList(transforms));
    }

    public Transforms add(@NonNull Iterable<Transform<?, ?>> transforms) {
        if (transforms == null) {
            throw new IllegalArgumentException("transforms is null");
        }
        List collected = Apikit.streamof(transforms).collect(Collectors.toList());
        this.transforms.addAll(collected);
        if (!collected.isEmpty()) {
            log.info("added transform(s): {}", collected);
        }
        return this;
    }

    public <A extends Asset, T> Optional<VirtualReader<T>> inferReader(@NonNull List<VirtualReader<?>> base, @NonNull AssetType type, @NonNull Class<T> targetApi) {
        if (base == null) {
            throw new IllegalArgumentException("base is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (targetApi == null) {
            throw new IllegalArgumentException("targetApi is null");
        }
        List<Transform<?, ?>> compatibleTransforms = this.transformsOver(type);
        return base.stream().filter(Transforms.compatibleWith(type)).map(compatibleReader -> this.$derive((VirtualReader)compatibleReader, compatibleTransforms, targetApi)).flatMap(derived -> derived.isPresent() ? Stream.of(derived.get()) : Stream.empty()).findAny();
    }

    public <T> Optional<VirtualWriter<T>> inferWriter(@NonNull List<VirtualWriter<?>> base, @NonNull AssetType type, @NonNull Class<T> targetApi) {
        if (base == null) {
            throw new IllegalArgumentException("base is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (targetApi == null) {
            throw new IllegalArgumentException("targetApi is null");
        }
        List<Transform<?, ?>> CompatibleTransforms = this.transformsOver(type);
        return base.stream().filter(Transforms.compatibleWith(type)).map(compatibleWriter -> this.$derive((VirtualWriter)compatibleWriter, CompatibleTransforms, targetApi)).flatMap(derived -> derived.isPresent() ? Stream.of(derived.get()) : Stream.empty()).findAny();
    }

    private Optional<VirtualReader> $derive(@NonNull VirtualReader reader, List<Transform<?, ?>> transforms, Class targetApi) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        return this.$derive(reader, transforms, targetApi, new ArrayList<Class>());
    }

    private Optional<VirtualReader> $derive(@NonNull VirtualReader reader, List<Transform<?, ?>> compatibleTransforms, Class targetApi, List<Class> premises) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        if (premises.contains(reader.api())) {
            return Optional.empty();
        }
        if (Utils.ordered(reader.api(), targetApi)) {
            return Optional.of(reader);
        }
        premises.add(reader.api());
        Stream<Optional> s = compatibleTransforms.stream().filter(Transforms.composeableWith(reader)).map(composeableTransform -> this.$derive(ReaderAdapter.adapt(reader, composeableTransform), compatibleTransforms, targetApi, premises));
        return s.flatMap(o -> o.isPresent() ? Stream.of(o.get()) : Stream.empty()).findAny();
    }

    private Optional<VirtualWriter> $derive(@NonNull VirtualWriter writer, List<Transform<?, ?>> transforms, Class target) {
        if (writer == null) {
            throw new IllegalArgumentException("writer is null");
        }
        return this.$derive(writer, transforms, target, new ArrayList<Class>());
    }

    private Optional<VirtualWriter> $derive(@NonNull VirtualWriter writer, @NonNull List<Transform<?, ?>> compatibleTransforms, Class targetApi, List<Class> premises) {
        if (writer == null) {
            throw new IllegalArgumentException("writer is null");
        }
        if (compatibleTransforms == null) {
            throw new IllegalArgumentException("compatibleTransforms is null");
        }
        if (premises.contains(writer.api())) {
            return Optional.empty();
        }
        if (Utils.ordered(writer.api(), targetApi)) {
            return Optional.of(writer);
        }
        premises.add(writer.api());
        Stream<Optional> s = compatibleTransforms.stream().filter(Transforms.composeableWith(writer)).map(composeableTransform -> this.$derive(WriterAdapter.adapt(writer, composeableTransform), compatibleTransforms, targetApi, premises));
        return s.flatMap(o -> o.isPresent() ? Stream.of(o.get()) : Stream.empty()).findAny();
    }

    private List<Transform<?, ?>> transformsOver(AssetType type) {
        return this.transforms.stream().filter(t -> Utils.ordered(type, t.type())).collect(Collectors.toList());
    }

    private static Predicate<Accessor<?>> compatibleWith(AssetType type) {
        return accessor -> Utils.ordered(type, accessor.type());
    }

    private static Predicate<Transform<?, ?>> composeableWith(VirtualReader<?> reader) {
        return transform -> Utils.ordered(reader.api(), transform.sourceApi());
    }

    private static Predicate<Transform<?, ?>> composeableWith(VirtualWriter<?> writer) {
        return transform -> Utils.ordered(transform.targetApi(), writer.api());
    }
}

