/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;

public interface NewsService {
    public Collection<NewsItem> news();

    public Collection<NewsItem> newsSince(Calendar var1);

    public static class NewsItem {
        private static DateFormat format = DateFormat.getDateTimeInstance();
        private final String text;
        private final long timestamp;

        public NewsItem(String text) {
            this(text, Calendar.getInstance());
        }

        public NewsItem(String text, Calendar timestamp) {
            this.text = text;
            this.timestamp = timestamp.getTimeInMillis();
        }

        public String text() {
            return this.text;
        }

        public Date timestamp() {
            return new Date(this.timestamp);
        }

        public boolean after(Calendar d) {
            return this.timestamp >= d.getTimeInMillis();
        }

        public String toString() {
            return "'" + this.text + "' (" + format.format(new Date(this.timestamp)) + ")";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NewsItem other = (NewsItem)obj;
            if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
                return false;
            }
            return this.timestamp == other.timestamp;
        }
    }
}

