/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.impl.delegation;

import javax.enterprise.event.Observes;
import org.cotrix.action.Action;
import org.cotrix.action.events.CodelistActionEvents;
import org.cotrix.common.cdi.Current;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.dsl.grammar.UserGrammar;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.repository.UserRepository;
import org.jboss.weld.context.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewVersionListener {
    private static Logger log = LoggerFactory.getLogger(NewVersionListener.class);

    static void delegateOnVersioning(@Observes CodelistActionEvents.Version event, @Current RequestContext ctx, @Current User user, UserRepository users) {
        if (!ctx.isActive()) {
            return;
        }
        log.info("delegating {}'s permissions to new version {} of {} ({})", new Object[]{user.name(), event.version, event.name, event.id});
        UserGrammar.UserChangeClause newuser = Users.modifyUser((User)user);
        for (Role role : user.directRoles()) {
            if (!role.resource().equals(event.oldId)) continue;
            newuser.is(new Role[]{role.on(event.id)});
        }
        for (Action permission : user.directPermissions()) {
            if (!permission.resource().equals(event.oldId)) continue;
            newuser.can(new Action[]{permission.on(event.id)});
        }
        User changeset = newuser.build();
        users.update((Object)changeset);
    }
}

