/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.changelog;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.application.ChangelogService;
import org.cotrix.application.changelog.Changelog;
import org.cotrix.application.changelog.ChangelogEntry;
import org.cotrix.application.changelog.ChangelogProducer;
import org.cotrix.common.CommonUtils;
import org.cotrix.common.async.CancelledTaskException;
import org.cotrix.common.async.TaskContext;
import org.cotrix.common.async.TaskUpdate;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Containers;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.utils.DomainUtils;
import org.cotrix.repository.CodelistQueries;
import org.cotrix.repository.CodelistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultChangelogService
implements ChangelogService {
    private static final Logger log = LoggerFactory.getLogger(DefaultChangelogService.class);
    private static Type logtype = new TypeToken<List<ChangelogEntry>>(){}.getType();
    @Inject
    private CodelistRepository codelists;

    @Override
    public void track(Codelist list, boolean optimised) {
        TaskContext context = new TaskContext();
        float progress = 0.0f;
        Containers.Codes codes = list.codes();
        int total = list.codes().size();
        long step = Math.round(Math.max(10.0, Math.floor(codes.size() / 10)));
        int i = 0;
        long time = System.currentTimeMillis();
        Date listCreated = CommonDefinition.CREATED.dateOf((Described)list);
        for (Code code : codes) {
            ++i;
            progress += 1.0f;
            Date codeUpdated = CommonDefinition.LAST_UPDATED.dateOf((Described)code);
            if (!optimised || codeUpdated != null && optimised && codeUpdated.after(listCreated)) {
                this.handleModifiedMarkerWith(code);
            }
            if ((long)i % step != 0L) continue;
            if (context.isCancelled()) {
                log.info("cahngelog tracking aborted on user request after {} codes.", (Object)i);
                throw new CancelledTaskException("changelog tracking aborted on user request");
            }
            context.save((Object)TaskUpdate.update((float)(progress / (float)total), (String)("tracked " + i + " codes")));
        }
        log.trace("tracked changelog for {} in {} msec.", (Object)DomainUtils.signatureOf((Codelist)list), (Object)(System.currentTimeMillis() - time));
    }

    public void trackAfter(Codelist.Private changeset) {
        Codelist list = (Codelist)this.codelists.lookup(changeset.id());
        this.trackPunctual((Codelist)Data.reveal((Codelist)list), changeset);
    }

    private void trackPunctual(Codelist list, Codelist.Private changeset) {
        boolean isVersion = CommonDefinition.PREVIOUS_VERSION.isIn((Described)list);
        for (Code.Private change : changeset.codes()) {
            if (change.status() == Status.DELETED) continue;
            Code code = (Code)list.codes().lookup(change.id());
            this.trackCode(code, change, isVersion);
        }
    }

    private void trackCode(Code changed, Code.Private change, boolean isVersion) {
        if (change.isChangeset()) {
            CommonDefinition.LAST_UPDATED.set(CommonUtils.time()).on((Described)changed);
            if (isVersion) {
                this.handleModifiedMarkerWith(changed);
            }
        } else {
            CommonDefinition.CREATED.set(CommonUtils.time()).on((Described)changed);
            if (isVersion) {
                CommonDefinition.NEW.set().on((Described)changed);
            }
        }
        CommonDefinition.UPDATED_BY.set(DomainUtils.currentUser().name()).on((Described)changed);
    }

    private void handleModifiedMarkerWith(Code changed) {
        Containers.Attributes attributes = changed.attributes();
        String originId = CommonDefinition.PREVIOUS_VERSION_ID.in(attributes);
        if (originId == null) {
            return;
        }
        Code origin = (Code)this.codelists.get(CodelistQueries.code((String)originId));
        if (origin == null) {
            log.error("cannot compute changelog for code {} as its lineage {} can't be retrieved.", (Object)changed.id(), (Object)originId);
            return;
        }
        ChangelogProducer producer = new ChangelogProducer();
        Changelog log = producer.changesBetween(origin, changed);
        if (log.isEmpty()) {
            CommonDefinition.MODIFIED.removeFrom(attributes);
            return;
        }
        if (CommonDefinition.MODIFIED.isIn(attributes)) {
            List oldentries = (List)CommonUtils.jsonBinder().fromJson(CommonDefinition.MODIFIED.in(attributes), logtype);
            log.addAll(oldentries);
        }
        List<ChangelogEntry> entries = log.entries();
        Collections.sort(entries);
        CommonDefinition.MODIFIED.set(CommonUtils.jsonBinder().toJson(entries, logtype)).on((Described)changed);
    }
}

