/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.logbook;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import org.cotrix.application.logbook.Logbook;
import org.cotrix.application.logbook.LogbookService;
import org.cotrix.common.CommonUtils;
import org.cotrix.common.events.ApplicationLifecycleEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Alternative
@Priority(value=1)
public class MLogbookService
implements LogbookService.Private {
    private static Logger log = LoggerFactory.getLogger(MLogbookService.class);
    private final Map<String, Logbook> books = new HashMap<String, Logbook>();

    @Override
    public void create(Logbook book) {
        CommonUtils.notNull((String)"logbook", (Object)book);
        this.books.put(book.resourceId(), book);
    }

    @Override
    public Logbook logbookOf(String id) {
        CommonUtils.notNull((String)"logbook identifier", (Object)id);
        return this.books.get(id);
    }

    @Override
    public void update(Logbook logbook) {
        CommonUtils.notNull((String)"logbook", (Object)logbook);
        Logbook book = this.books.get(logbook.resourceId());
        if (book == null) {
            log.warn("cannot update logbook for {} (maybe it has already been removed?)", (Object)logbook.resourceId());
        } else {
            log.info("updated logbook for {} ", (Object)logbook.resourceId());
        }
    }

    @Override
    public void removeLogbookOf(String id) {
        CommonUtils.notNull((String)"logbook identifier", (Object)id);
        if (this.books.remove(id) == null) {
            log.warn("cannot remove logbook for {} (maybe it has already been removed?)", (Object)id);
        }
    }

    public void clear(@Observes ApplicationLifecycleEvents.Shutdown event) {
        this.books.clear();
    }
}

