/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import javax.inject.Inject;
import org.cotrix.application.StatisticsService;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.repository.UserRepository;
import org.cotrix.test.ApplicationTest;
import org.junit.Assert;
import org.junit.Test;

public class StatisticsServiceTest
extends ApplicationTest {
    @Inject
    StatisticsService service;
    @Inject
    CodelistRepository repository;
    @Inject
    UserRepository uRepository;

    @Test
    public void statistics() {
        Code c1 = (Code)((CodeGrammar.SecondClause)Data.code().name("c1")).build();
        Code c2 = (Code)((CodeGrammar.SecondClause)Data.code().name("c2")).build();
        Code c3 = (Code)((CodeGrammar.SecondClause)Data.code().name("c3")).build();
        Codelist l1 = (Codelist)((CodelistGrammar.SecondClause)Data.codelist().name("test")).with(new Code[]{c1, c2}).build();
        Codelist l2 = (Codelist)((CodelistGrammar.SecondClause)Data.codelist().name("test2")).with(new Code[]{c3}).build();
        this.repository.add((Object)l1);
        this.repository.add((Object)l2);
        StatisticsService.Statistics s = this.service.statistics();
        Assert.assertEquals((long)2L, (long)s.totalCodelists());
        Assert.assertEquals((long)3L, (long)s.totalCodes());
    }

    @Test
    public void statisticsOnEmptySet() {
        StatisticsService.Statistics s = this.service.statistics();
        Assert.assertEquals((long)0L, (long)s.totalCodelists());
        Assert.assertEquals((long)0L, (long)s.totalCodes());
    }
}

