/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.application.logbook;

import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.cotrix.action.CodelistAction;
import org.cotrix.action.events.CodelistActionEvents;
import org.cotrix.application.logbook.Logbook;
import org.cotrix.application.logbook.LogbookEvent;
import org.cotrix.application.logbook.LogbookService;
import org.cotrix.common.events.After;
import org.cotrix.common.events.Before;
import org.cotrix.common.events.New;
import org.cotrix.common.events.Removed;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.trait.Described;
import org.cotrix.lifecycle.LifecycleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodelistObserver {
    private static Logger log = LoggerFactory.getLogger(CodelistObserver.class);
    @Inject
    private LogbookService.Private service;

    public void onCodelistCreated(@Observes @After @New Codelist list) {
        try {
            Logbook book = new Logbook(list.id());
            book.add(LogbookEvent.CREATED.entry());
            String previousVersion = CommonDefinition.PREVIOUS_VERSION_ID.of((Described)list);
            if (previousVersion != null) {
                book.add(LogbookEvent.VERSIONED.entryWith("versioned from:" + previousVersion));
            }
            this.service.create(book);
            log.trace("created logbook for codelist {}", (Object)this.signatureOf(list));
        }
        catch (RuntimeException e) {
            log.error("cannot create logbook for codelist {}", (Object)this.signatureOf(list));
            throw e;
        }
    }

    public void onCodelistRemoved(@Observes @Before @Removed Codelist list) {
        try {
            Logbook book = this.service.logbookOf(list.id());
            if (book == null) {
                log.warn("cannot find logbook of codelist being removed {}", (Object)this.signatureOf(list));
            } else {
                this.service.removeLogbookOf(list.id());
                log.trace("removed logbook for codelist {}", (Object)this.signatureOf(list));
            }
        }
        catch (RuntimeException e) {
            log.error("cannot remove logbook for codelist {}" + this.signatureOf(list), (Throwable)e);
        }
    }

    public void onCodelistImported(@Observes CodelistActionEvents.Import event) {
        Logbook book = this.service.logbookOf(event.codelistId);
        if (book == null) {
            log.warn("no logbook for imported codelist {}", (Object)this.signatureOf((CodelistActionEvents.CodelistEvent)event));
        } else {
            book.add(LogbookEvent.IMPORTED.entryWith(event.origin));
            this.service.update(book);
        }
    }

    public void onLifecycleChange(@Observes LifecycleEvent event) {
        Logbook book = this.service.logbookOf(event.resourceId());
        if (book == null) {
            log.warn("no logbook for changed codelist {}", (Object)event.resourceId());
        } else if (event.action().equals(CodelistAction.SEAL.on(event.resourceId()))) {
            book.add(LogbookEvent.SEALED.entry());
            this.service.update(book);
        } else if (event.action().equals(CodelistAction.LOCK.on(event.resourceId()))) {
            book.add(LogbookEvent.LOCKED.entry());
            this.service.update(book);
        }
    }

    public void onCodelistPublished(@Observes CodelistActionEvents.Publish event) {
        Logbook book = this.service.logbookOf(event.codelistId);
        if (book == null) {
            log.warn("no logbook for published codelist {}", (Object)this.signatureOf((CodelistActionEvents.CodelistEvent)event));
        } else {
            book.add(LogbookEvent.PUBLISHED.entryWith(event.repository));
            this.service.update(book);
        }
    }

    public void onCodelistVersioned(@Observes CodelistActionEvents.Version event) {
        Logbook book = this.service.logbookOf(event.oldId);
        if (book == null) {
            log.warn("no logbook for versioned codelist {}", (Object)this.signatureOf((CodelistActionEvents.CodelistEvent)event));
        } else {
            book.add(LogbookEvent.VERSIONED.entryWith("versioned to:" + event.codelistVersion));
            this.service.update(book);
        }
    }

    private String signatureOf(Codelist list) {
        return this.signatureOf(list.id(), list.qname(), list.version());
    }

    private String signatureOf(CodelistActionEvents.CodelistEvent event) {
        return this.signatureOf(event.codelistId, event.codelistName, event.codelistVersion);
    }

    private String signatureOf(String id, QName name, String version) {
        return String.format("%s  (%s v.%s)", id, name, version);
    }
}

