/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.cotrix.application.ChangelogService;
import org.cotrix.application.VersioningService;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.dsl.grammar.AttributeDefinitionGrammar;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.user.User;
import org.cotrix.domain.utils.DomainConstants;
import org.cotrix.repository.CodelistActions;
import org.cotrix.repository.CodelistQueries;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.repository.Query;
import org.cotrix.repository.UserRepository;
import org.cotrix.test.ApplicationTest;
import org.cotrix.test.TestUser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangelogTest
extends ApplicationTest {
    AttributeDefinition def = (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.attrdef().name("a")).build();
    Attribute a = (Attribute)Data.attribute().instanceOf(this.def).build();
    Attribute same = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name("same")).build();
    Code code = (Code)((CodeGrammar.SecondClause)((CodeGrammar.SecondClause)Data.code().name("c")).attributes(new Attribute[]{this.a, this.same})).build();
    Codelist list = (Codelist)((CodelistGrammar.SecondClause)Data.codelist().name("l")).definitions(new AttributeDefinition[]{this.def}).with(new Code[]{this.code}).build();
    Codelist vlist;
    Code vcode;
    @Inject
    VersioningService service;
    @Inject
    ChangelogService changelog;
    @Inject
    CodelistRepository codelists;
    @Inject
    UserRepository users;
    @Inject
    TestUser user;

    @Before
    public void prepareVersion() {
        this.users.add((Object)this.user.get());
        this.codelists.add((Object)this.list);
        this.vlist = this.service.bump(this.list).to("2");
        this.codelists.add((Object)this.vlist);
        this.vcode = (Code)this.vlist.codes().getFirst((Named)this.code);
    }

    @Test
    public void codelistsOnlyAreMarkedOnStorage() {
        Assert.assertTrue((boolean)CommonDefinition.CREATED.isIn((Described)this.list));
        Assert.assertFalse((boolean)CommonDefinition.CREATED.isIn((Described)this.code));
        Assert.assertTrue((boolean)CommonDefinition.CREATED.isIn((Described)this.vlist));
        Assert.assertFalse((boolean)CommonDefinition.CREATED.isIn((Described)this.vcode));
    }

    @Test
    public void newCodesAreTimeStampedOnUpdate() {
        Code newcode = (Code)((CodeGrammar.SecondClause)Data.code().name("newcode")).build();
        this.codelists.update(Data.modify((Codelist)this.list).with(new Code[]{newcode}));
        Assert.assertTrue((boolean)CommonDefinition.CREATED.isIn((Described)newcode));
        Assert.assertTrue((boolean)CommonDefinition.UPDATED_BY.isIn((Described)newcode));
        Assert.assertFalse((boolean)CommonDefinition.NEW.isIn((Described)newcode));
        Assert.assertFalse((boolean)CommonDefinition.MODIFIED.isIn((Described)newcode));
        Assert.assertFalse((boolean)CommonDefinition.LAST_UPDATED.isIn((Described)newcode));
    }

    @Test
    public void newCodesAreTimeStampedAndMarkedOnAllUpdatesToVersions() {
        Code newcode = (Code)((CodeGrammar.SecondClause)Data.code().name("newcode")).build();
        this.codelists.update(Data.modify((Codelist)this.vlist).with(new Code[]{newcode}));
        Assert.assertTrue((boolean)CommonDefinition.CREATED.isIn((Described)newcode));
        Assert.assertTrue((boolean)CommonDefinition.UPDATED_BY.isIn((Described)newcode));
        Assert.assertTrue((boolean)CommonDefinition.NEW.isIn((Described)newcode));
        Assert.assertFalse((boolean)CommonDefinition.MODIFIED.isIn((Described)newcode));
        Assert.assertFalse((boolean)CommonDefinition.LAST_UPDATED.isIn((Described)newcode));
    }

    @Test
    public void changesAreTimestampedOnUpdate() {
        this.codelists.update(Data.modify((Codelist)this.list).with(new CodeGrammar.SecondClause[]{(CodeGrammar.SecondClause)Data.modify((Code)this.code).name("modified")}));
        Assert.assertTrue((boolean)CommonDefinition.LAST_UPDATED.isIn((Described)this.code));
        Assert.assertTrue((boolean)CommonDefinition.UPDATED_BY.isIn((Described)this.code));
        Assert.assertFalse((boolean)CommonDefinition.CREATED.isIn((Described)this.code));
        Assert.assertFalse((boolean)CommonDefinition.NEW.isIn((Described)this.code));
        Assert.assertFalse((boolean)CommonDefinition.MODIFIED.isIn((Described)this.code));
    }

    @Test
    public void changesAreTimestampedAndMarkedOnUpdateToVersions() {
        this.codelists.update(Data.modify((Codelist)this.vlist).with(new CodeGrammar.SecondClause[]{(CodeGrammar.SecondClause)Data.modify((Code)this.vcode).name("modified")}));
        Assert.assertTrue((boolean)CommonDefinition.LAST_UPDATED.isIn((Described)this.vcode));
        Assert.assertTrue((boolean)CommonDefinition.UPDATED_BY.isIn((Described)this.vcode));
        Assert.assertTrue((boolean)CommonDefinition.MODIFIED.isIn((Described)this.vcode));
        Assert.assertFalse((boolean)CommonDefinition.CREATED.isIn((Described)this.vcode));
        Assert.assertFalse((boolean)CommonDefinition.NEW.isIn((Described)this.vcode));
    }

    @Test
    public void attrChangesAreMarkedOnUpdateToVersions() throws Exception {
        Attribute vattr = (Attribute)this.vcode.attributes().getFirst((Named)this.a);
        Attribute modattr = (Attribute)((AttributeGrammar.FourthClause)Data.modify((Attribute)vattr).name("aa")).in("en").ofType(DomainConstants.NAME_TYPE).value("someval").build();
        Attribute newattr = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name("b")).value("val").build();
        this.codelists.update(Data.modify((Codelist)this.vlist).with(new CodeGrammar.SecondClause[]{(CodeGrammar.SecondClause)((CodeGrammar.SecondClause)Data.modify((Code)this.vcode).name("cc")).attributes(new Attribute[]{modattr, newattr})}));
        Assert.assertNotNull((Object)CommonDefinition.MODIFIED.of((Described)this.vcode));
        Thread.sleep(1000L);
        User fifi = Users.user().name("fifi").fullName("fifi").noMail().build();
        this.user.set(fifi);
        Attribute newattr2 = (Attribute)((AttributeGrammar.FourthClause)Data.attribute().name("c")).value("val").build();
        this.codelists.update(Data.modify((Codelist)this.vlist).with(new CodeGrammar.SecondClause[]{(CodeGrammar.SecondClause)Data.modify((Code)this.vcode).attributes(new Attribute[]{newattr2})}));
        System.out.println(CommonDefinition.MODIFIED.of((Described)this.vcode));
    }

    @Test
    public void definitionChangesAreDetected() throws Exception {
        AttributeDefinition vdef = (AttributeDefinition)this.vlist.attributeDefinitions().getFirst((Named)this.def);
        Thread.sleep(1000L);
        this.codelists.update(Data.modify((Codelist)this.vlist).definitions(new AttributeDefinitionGrammar.SecondClause[]{(AttributeDefinitionGrammar.SecondClause)Data.modify((AttributeDefinition)vdef).name("new")}));
        this.changelog.track(this.vlist, false);
        System.out.println(CommonDefinition.MODIFIED.of((Described)this.vcode));
    }

    @Test
    public void definitionRemovalsAreDetected() throws Exception {
        AttributeDefinition vdef = (AttributeDefinition)this.vlist.attributeDefinitions().getFirst((Named)this.def);
        Thread.sleep(1000L);
        this.codelists.update(this.vlist.id(), CodelistActions.deleteAttrdef((String)vdef.id()));
        this.changelog.track(this.vlist, false);
        System.out.println(CommonDefinition.MODIFIED.of((Described)this.vcode));
    }

    @Test
    public void codesChangedSince() throws Exception {
        Code c1 = (Code)((CodeGrammar.SecondClause)Data.code().name("c1")).build();
        Code c2 = (Code)((CodeGrammar.SecondClause)Data.code().name("c2")).build();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Data.codelist().name("name")).with(new Code[]{c1, c2}).build();
        this.codelists.add((Object)list);
        Date checkpoint = Calendar.getInstance().getTime();
        TimeUnit.SECONDS.sleep(1L);
        Code c3 = (Code)((CodeGrammar.SecondClause)Data.code().name("c3")).build();
        Codelist changeset = (Codelist)Data.modify((Codelist)list).with(new Code[]{c3, (Code)((CodeGrammar.SecondClause)Data.modify((Code)c1).name("newname")).build()}).build();
        this.codelists.update((Object)changeset);
        Iterable codes = (Iterable)this.codelists.get((Query)CodelistQueries.codesSince((Date)checkpoint).in(list.id()));
        Assert.assertEquals(Arrays.asList(c1, c3), (Object)CommonUtils.collect((Iterable)codes));
    }
}

