/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.common;

import java.util.ArrayList;
import java.util.List;
import org.cotrix.common.Utils;

public class Report {
    private static InheritableThreadLocal<Report> reports = new InheritableThreadLocal<Report>(){

        @Override
        protected Report initialValue() {
            return new Report();
        }
    };
    private final double start = System.currentTimeMillis();
    private List<Log> logs = new ArrayList<Log>();
    private boolean failure;

    public static Report report() {
        return (Report)reports.get();
    }

    private Report() {
    }

    public List<Log> logs() {
        return this.logs;
    }

    public void log(String message, Log.Type type) {
        Utils.valid("message", message);
        this.logs.add(Log.get("[" + this.time() + "s] " + message, type));
    }

    public void log(String message) {
        this.log(message, Log.Type.INFO);
    }

    public void logWarning(String message) {
        this.log(message, Log.Type.WARN);
    }

    public void logError(String message) {
        this.log(message, Log.Type.ERROR);
        this.failure = true;
    }

    public void close() {
        reports.remove();
    }

    public boolean isFailure() {
        return this.failure;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Log log : this.logs) {
            builder.append(log).append("\n");
        }
        return builder.toString();
    }

    private double time() {
        return ((double)System.currentTimeMillis() - this.start) / 1000.0;
    }

    public static class Log {
        final String msg;
        final Type type;

        public static Log get(String msg, Type type) {
            return new Log(msg, type);
        }

        private Log(String msg, Type type) {
            this.msg = msg;
            this.type = type;
        }

        public String message() {
            return this.msg;
        }

        public Type type() {
            return this.type;
        }

        public String toString() {
            return (Object)((Object)this.type) + ":" + this.msg;
        }

        public static enum Type {
            WARN,
            ERROR,
            INFO;

        }
    }
}

