/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.common.tx;

import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.cotrix.common.tx.Transaction;
import org.cotrix.common.tx.Transactional;
import org.cotrix.common.tx.Transactions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
@Transactional
@Priority(value=1000)
public class TransactionInterceptor {
    protected Logger log = LoggerFactory.getLogger(TransactionInterceptor.class);
    @Inject
    Transactions transactions;

    @AroundInvoke
    public Object executeAsTransaction(InvocationContext ctx) throws Exception {
        if (ctx.getMethod().isAnnotationPresent(Transactional.class) || ctx.getMethod().getDeclaringClass().isAnnotationPresent(Transactional.class)) {
            try (Transaction tx = this.transactions.open();){
                this.log.trace("in transaction for {}", (Object)ctx.getMethod());
                long time = System.currentTimeMillis();
                Object result = ctx.proceed();
                this.log.trace("transaction for {} complete in {} ms.", (Object)ctx.getMethod(), (Object)(System.currentTimeMillis() - time));
                tx.commit();
                Object object = result;
                return object;
            }
        }
        return ctx.proceed();
    }
}

