/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.common;

import java.lang.annotation.Annotation;
import javax.enterprise.event.Event;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.common.events.ApplicationLifecycleEvents;
import org.cotrix.common.tx.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApplicationLifecycle {
    private static Logger log = LoggerFactory.getLogger(ApplicationLifecycle.class);
    @Inject
    private Event<ApplicationLifecycleEvents.ApplicationEvent> events;
    private AnnotationLiteral<? extends Annotation> scenario;

    @Transactional
    public void start() {
        this.scenario = new AnnotationLiteral<ApplicationLifecycleEvents.FirstTime>(){};
        log.info("application is starting...");
        this.events.fire((Object)ApplicationLifecycleEvents.Startup.INSTANCE);
        log.info("application is staging...({})", (Object)this.scenario.annotationType().getSimpleName().toLowerCase());
        this.events.select(new Annotation[]{this.scenario}).fire((Object)ApplicationLifecycleEvents.Ready.INSTANCE);
    }

    public void markAsRestart() {
        this.scenario = new AnnotationLiteral<ApplicationLifecycleEvents.Restart>(){};
    }

    public void stop() {
        log.info("application is stopping...");
        this.events.fire((Object)ApplicationLifecycleEvents.Shutdown.INSTANCE);
    }
}

