/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.cotrix.configuration.LocationProvider;
import org.cotrix.configuration.utils.CdiProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationLocator {
    private static Logger log = LoggerFactory.getLogger(ConfigurationLocator.class);
    private final Iterable<LocationProvider> providers;

    @Inject
    public ConfigurationLocator(Instance<LocationProvider> providers) {
        this((Iterable<LocationProvider>)providers);
    }

    public ConfigurationLocator(Iterable<LocationProvider> providers) {
        this.providers = providers;
    }

    public InputStream locate() throws IllegalStateException {
        for (LocationProvider provider : this.providers) {
            String location = provider.location();
            if (location == "_pass_") continue;
            try {
                return this.resolve(location);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException(" cannot access the configuration @ " + location + " (" + provider.getClass().getCanonicalName() + ")", e);
            }
        }
        return this.defaultConfiguration();
    }

    private InputStream resolve(String location) {
        if (location == null) {
            throw new RuntimeException("location is undefined");
        }
        File file = new File(location);
        if (!file.exists() || !file.canRead() || file.isDirectory()) {
            throw new RuntimeException("configuration @ " + file + " does not exist, cannot be read, or is a directory");
        }
        try {
            FileInputStream stream = new FileInputStream(file);
            log.info("using configuration @ {}", (Object)file);
            return stream;
        }
        catch (Exception e) {
            throw new RuntimeException("cannot read configuration @ " + file, e);
        }
    }

    private InputStream defaultConfiguration() {
        log.info("no configuration provided: using defaults");
        InputStream stream = CdiProducer.class.getResourceAsStream("/default-configuration.xml");
        if (stream == null) {
            throw new AssertionError((Object)"no default configuration: invalid distribution?");
        }
        return stream;
    }
}

