/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.configuration;

import java.io.File;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.cotrix.common.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LocationProvider {
    public static final String PASS = "_pass_";

    public String location();

    public static class WorkingDir
    implements LocationProvider {
        @Override
        public String location() {
            String location = System.getProperty("user.dir");
            if (location == null) {
                return LocationProvider.PASS;
            }
            File file = new File(location, "cotrix.xml");
            return Utils.isValid((File)file) ? file.getAbsolutePath() : LocationProvider.PASS;
        }
    }

    public static class HomeDir
    implements LocationProvider {
        @Override
        public String location() {
            String location = System.getProperty("user.home");
            if (location == null) {
                return LocationProvider.PASS;
            }
            File file = new File(location, "cotrix.xml");
            return Utils.isValid((File)file) ? file.getAbsolutePath() : LocationProvider.PASS;
        }
    }

    public static class EnvProvider
    implements LocationProvider {
        @Override
        public String location() {
            return System.getenv().containsKey("cotrix.config") ? System.getenv("cotrix.config") : LocationProvider.PASS;
        }
    }

    public static class SystemProperty
    implements LocationProvider {
        @Override
        public String location() {
            String property = System.getProperty("cotrix.config");
            return property == null ? LocationProvider.PASS : property;
        }
    }

    public static class Jndi
    implements LocationProvider {
        private static Logger log = LoggerFactory.getLogger(Jndi.class);

        @Override
        public String location() {
            try {
                Context ctx = (Context)new InitialContext().lookup("java:comp/env");
                return (String)ctx.lookup("cotrix.config");
            }
            catch (Exception e) {
                log.info("no configuraton available via JNDI");
                return LocationProvider.PASS;
            }
        }
    }
}

