/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.common;

import javax.xml.namespace.QName;
import org.cotrix.domain.trait.EntityProvider;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.utils.Constants;

public interface Attribute
extends Identified,
Named {
    public QName type();

    public String value();

    public String language();

    public static final class Private
    extends Identified.Abstract<Private, State>
    implements Attribute {
        public Private(State state) {
            super(state);
        }

        @Override
        public QName name() {
            return ((State)this.state()).name();
        }

        @Override
        public QName type() {
            return ((State)this.state()).type();
        }

        @Override
        public String value() {
            return ((State)this.state()).value();
        }

        @Override
        public String language() {
            return ((State)this.state()).language();
        }

        @Override
        public void update(Private changeset) throws IllegalArgumentException, IllegalStateException {
            super.update(changeset);
            if (changeset.name() != null) {
                if (changeset.name() == Constants.NULL_QNAME) {
                    throw new IllegalArgumentException("attribute name " + this.name() + " cannot be erased");
                }
                ((State)this.state()).name(changeset.name());
            }
            if (changeset.type() != null) {
                ((State)this.state()).type(changeset.type() == Constants.NULL_QNAME ? null : changeset.type());
            }
            if (changeset.value() != null) {
                ((State)this.state()).value(changeset.value() == "__ignore__" ? null : changeset.value());
            }
            if (changeset.language() != null) {
                ((State)this.state()).language(changeset.language() == "__ignore__" ? null : changeset.language());
            }
        }

        public String toString() {
            return "Attribute [id=" + this.id() + ", name=" + this.name() + ", value=" + this.value() + ", language=" + this.language() + (this.type() == null ? "" : ", type=" + this.type()) + (this.status() == null ? "" : " (" + (Object)((Object)this.status()) + ") ") + "]";
        }
    }

    public static interface State
    extends Identified.State,
    Named.State,
    EntityProvider<Private> {
        public QName type();

        public void type(QName var1);

        public String value();

        public void value(String var1);

        public String language();

        public void language(String var1);
    }
}

