/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.cotrix.action.Action;
import org.cotrix.action.CodelistAction;
import org.cotrix.action.MainAction;
import org.cotrix.action.ResourceType;
import org.cotrix.action.UserAction;
import org.cotrix.domain.dsl.builder.UserBuilder;
import org.cotrix.domain.dsl.grammar.UserGrammar;
import org.cotrix.domain.memory.UserMS;
import org.cotrix.domain.user.Role;

public class Roles {
    public static Role USER = Roles.role("user").can(new Action[]{CodelistAction.VIEW, MainAction.ACCESS_ADMIN_AREA}).buildAsRoleFor(ResourceType.application);
    public static Role MANAGER = Roles.role("manager").is(USER).can(new Action[]{MainAction.IMPORT, MainAction.PUBLISH}).buildAsRoleFor(ResourceType.application);
    public static Role EDITOR = Roles.role("editor").is(USER).can(new Action[]{CodelistAction.EDIT}).buildAsRoleFor(ResourceType.codelists);
    public static Role REVIEWER = Roles.role("reviewer").is(USER, EDITOR).can(new Action[]{CodelistAction.LOCK, CodelistAction.UNLOCK}).buildAsRoleFor(ResourceType.codelists);
    public static Role PUBLISHER = Roles.role("publisher").is(USER).can(new Action[]{CodelistAction.PUBLISH, MainAction.PUBLISH}).buildAsRoleFor(ResourceType.codelists);
    public static Role OWNER = Roles.role("owner").is(USER, EDITOR, REVIEWER, PUBLISHER).can((Action[])CodelistAction.values()).buildAsRoleFor(ResourceType.codelists);
    public static Role ROOT = Roles.role("root").can((Action[])MainAction.values()).can((Action[])CodelistAction.values()).can((Action[])UserAction.values()).is(USER, MANAGER, OWNER).buildAsRoleFor(ResourceType.application);
    public static Collection<Role> predefinedRoles = Arrays.asList(ROOT, USER, MANAGER, OWNER, REVIEWER, EDITOR, PUBLISHER);

    public static UserGrammar.ThirdClause role(String name) {
        return new UserBuilder(new UserMS(name)).name(name).fullName(name).noMail();
    }

    public static Collection<Role> getBy(ResourceType ... types) {
        ArrayList<Role> roles = new ArrayList<Role>();
        block0: for (Role role : predefinedRoles) {
            for (ResourceType type : types) {
                if (role.type() != type) continue;
                roles.add(role);
                continue block0;
            }
        }
        return roles;
    }
}

