/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.codelist;

import java.util.ArrayList;
import java.util.HashMap;
import org.cotrix.domain.codelist.Codelink;
import org.cotrix.domain.common.Container;
import org.cotrix.domain.common.NamedContainer;
import org.cotrix.domain.common.NamedStateContainer;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.memory.CodelinkMS;
import org.cotrix.domain.trait.Attributed;
import org.cotrix.domain.trait.EntityProvider;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.trait.Status;

public interface Code
extends Identified,
Attributed,
Named {
    public NamedContainer<? extends Codelink> links();

    public static final class Private
    extends Named.Abstract<Private, State>
    implements Code {
        public Private(State state) {
            super(state);
        }

        public NamedContainer.Private<Codelink.Private, Codelink.State> links() {
            return Codes.namedContainer(((State)this.state()).links());
        }

        @Override
        public void update(Private changeset) throws IllegalArgumentException, IllegalStateException {
            super.update(changeset);
            this.updateLinks(changeset);
        }

        private void updateLinks(Private changeset) {
            HashMap<String, State> redirected = new HashMap<String, State>();
            for (Codelink.State change : ((State)changeset.state()).links()) {
                if (change.target() == null) continue;
                redirected.put(change.id(), change.target());
            }
            if (redirected.isEmpty()) {
                ((Container.Abstract)((Object)this.links())).update(changeset.links());
                return;
            }
            HashMap<String, State> targetUpdates = new HashMap<String, State>();
            for (Codelink.State link : ((State)this.state()).links()) {
                if (!redirected.containsKey(link.id())) continue;
                State update = (State)redirected.get(link.id());
                String current = link.target().id();
                State knownUpdate = (State)targetUpdates.get(current);
                if (knownUpdate == null) {
                    targetUpdates.put(current, update);
                    continue;
                }
                if (knownUpdate.id().equals(update.id())) continue;
                throw new IllegalArgumentException("invalid changeset: two links with the same target must change it consistently");
            }
            ((Container.Abstract)((Object)this.links())).update(changeset.links());
            ArrayList<CodelinkMS> changes = new ArrayList<CodelinkMS>();
            for (Codelink.State link : ((State)this.state()).links()) {
                String target = link.target().id();
                if (!targetUpdates.containsKey(target)) continue;
                CodelinkMS change = new CodelinkMS(link.id(), Status.MODIFIED);
                change.target((State)targetUpdates.get(target));
                changes.add(change);
            }
            ((Container.Abstract)((Object)this.links())).update(Codes.namedContainer(Codes.namedBeans(changes)));
        }

        public String toString() {
            return "Code [id=" + this.id() + ", name=" + this.name() + ", attributes=" + this.attributes() + ", links=" + this.links() + "]";
        }
    }

    public static interface State
    extends Identified.State,
    Named.State,
    Attributed.State,
    EntityProvider<Private> {
        public NamedStateContainer<Codelink.State> links();
    }
}

