/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.codelist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.links.ValueFunction;
import org.cotrix.domain.trait.Attributed;
import org.cotrix.domain.trait.EntityProvider;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;

public interface Codelink
extends Identified,
Attributed,
Named {
    public CodelistLink type();

    public List<Object> value();

    public Code target();

    public static class Private
    extends Attributed.Abstract<Private, State>
    implements Codelink {
        public Private(State state) {
            super(state);
        }

        @Override
        public QName name() {
            return ((State)this.state()).type().name();
        }

        @Override
        public List<Object> value() {
            return Private.resolve((State)this.state(), (CodelistLink.State)this.type().state(), new ArrayList<String>());
        }

        @Override
        public Code target() {
            return new Code.Private(((State)this.state()).target());
        }

        @Override
        public CodelistLink.Private type() {
            return new CodelistLink.Private(((State)this.state()).type());
        }

        @Override
        public void update(Private changeset) throws IllegalArgumentException, IllegalStateException {
            super.update(changeset);
            Code.State newtarget = ((State)changeset.state()).target();
            if (newtarget != null) {
                ((State)this.state()).target(newtarget);
            }
        }

        public String toString() {
            return "Codelink [id=" + this.id() + ", type=" + ((State)this.state()).type() + " :--> " + ((State)this.state()).target().id() + "]";
        }

        public static List<Object> resolve(State link, CodelistLink.State type, List<String> ids) {
            if (ids.contains(link.id())) {
                StringBuilder cycle = new StringBuilder();
                for (String id : ids) {
                    cycle.append(id + "->");
                }
                cycle.append(link.id());
                throw new IllegalStateException("cycle detected:" + cycle);
            }
            ids.add(link.id());
            if (link.target() == null) {
                return Collections.emptyList();
            }
            List<Object> values = type.valueType().valueIn(link.id(), link.target(), ids);
            ArrayList<Object> results = new ArrayList<Object>();
            ValueFunction function = type.function();
            for (Object value : values) {
                Object result = null;
                if (value instanceof QName) {
                    QName name = (QName)value;
                    result = new QName(name.getNamespaceURI(), function.apply(name.getLocalPart()));
                } else {
                    String val = (String)value;
                    result = function.apply(val);
                }
                results.add(result);
            }
            return results;
        }
    }

    public static interface State
    extends Identified.State,
    Attributed.State,
    Named.State,
    EntityProvider<Private> {
        public CodelistLink.State type();

        public void type(CodelistLink.State var1);

        public Code.State target();

        public void target(Code.State var1);
    }
}

