/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.links;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.cotrix.common.Utils;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelink;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.links.NameLink;
import org.cotrix.domain.links.ValueType;
import org.cotrix.domain.utils.Constants;

public class LinkOfLink
implements ValueType {
    private CodelistLink target;

    public LinkOfLink(CodelistLink template) {
        Utils.notNull((String)"template", (Object)template);
        if (Codes.reveal(template).isChangeset()) {
            throw new IllegalArgumentException("link template cannot be a changeset");
        }
        this.target = template;
    }

    public CodelistLink target() {
        return this.target;
    }

    @Override
    public List<Object> valueIn(String id, Code.State code, List<String> ids) {
        ArrayList<Object> matches = new ArrayList<Object>();
        for (Codelink.State link : code.links()) {
            CodelistLink.State linktype = link.type();
            if (!this.matches(linktype)) continue;
            for (Object match : Codelink.Private.resolve(link, linktype, ids)) {
                matches.add(match);
            }
        }
        return matches;
    }

    public boolean matches(CodelistLink link) {
        return this.matches((CodelistLink.State)Codes.reveal(link).state());
    }

    public boolean matches(CodelistLink.State link) {
        QName name = this.target.name();
        String id = this.target.target() == null ? null : this.target.target().id();
        ValueType type = this.target.valueType();
        return this.matches(name, link.name()) && this.matches(id, link.target()) && this.matches(type == null ? NameLink.INSTANCE : type, link.valueType());
    }

    private boolean matches(String id, Codelist.State val) {
        return id == null || val != null && id.equals(val.id());
    }

    private boolean matches(Object templ, Object val) {
        return templ == null || templ.equals(Constants.NULL_QNAME) || templ.equals("__ignore__") || templ.equals(val);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkOfLink other = (LinkOfLink)obj;
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }
}

