/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.attributes;

import javax.xml.namespace.QName;
import org.cotrix.domain.common.Range;
import org.cotrix.domain.trait.EntityProvider;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.utils.Constants;
import org.cotrix.domain.values.ValueType;

public interface Definition
extends Identified,
Named {
    public QName type();

    public String language();

    public ValueType valueType();

    public Range range();

    public boolean isShared();

    public static class Private
    extends Identified.Abstract<Private, State>
    implements Definition {
        public Private(State state) {
            super(state);
        }

        @Override
        public boolean isShared() {
            return ((State)this.state()).isShared();
        }

        @Override
        public QName name() {
            return ((State)this.state()).name();
        }

        @Override
        public QName type() {
            return ((State)this.state()).type();
        }

        @Override
        public String language() {
            return ((State)this.state()).language();
        }

        @Override
        public ValueType valueType() {
            return ((State)this.state()).valueType();
        }

        @Override
        public Range range() {
            return ((State)this.state()).range();
        }

        @Override
        public void update(Private changeset) throws IllegalArgumentException, IllegalStateException {
            Range newrange;
            ValueType newtype;
            super.update(changeset);
            if (changeset.name() == Constants.NULL_QNAME) {
                throw new IllegalArgumentException("attribute name " + this.name() + " cannot be erased");
            }
            if (changeset.name() != null) {
                ((State)this.state()).name(changeset.name());
            }
            if (changeset.type() == Constants.NULL_QNAME) {
                throw new IllegalArgumentException("attribute type " + this.type() + " cannot be erased");
            }
            if (changeset.type() != null) {
                ((State)this.state()).type(changeset.type());
            }
            if (changeset.language() != null) {
                ((State)this.state()).language(changeset.language() == "__ignore__" ? null : changeset.language());
            }
            if ((newtype = changeset.valueType()) != null) {
                ((State)this.state()).valueType(newtype);
            }
            if ((newrange = changeset.range()) != null) {
                ((State)this.state()).range(newrange);
            }
        }

        public String toString() {
            return "def [id=" + this.id() + ", shared=" + this.isShared() + ", name=" + this.name() + ", range=" + this.range() + ", valueType=" + this.valueType() + ", language=" + this.language() + (this.type() == null ? "" : ", type=" + this.type()) + (this.status() == null ? "" : " (" + (Object)((Object)this.status()) + ") ") + "]";
        }
    }

    public static interface State
    extends Identified.State,
    Named.State,
    EntityProvider<Private> {
        public QName type();

        public void type(QName var1);

        public String language();

        public void language(String var1);

        public ValueType valueType();

        public void valueType(ValueType var1);

        public Range range();

        public void range(Range var1);

        public boolean isShared();
    }
}

