/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.memory;

import javax.xml.namespace.QName;
import org.cotrix.common.Utils;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.common.Range;
import org.cotrix.domain.memory.IdentifiedMS;
import org.cotrix.domain.trait.Status;
import org.cotrix.domain.utils.Constants;
import org.cotrix.domain.values.ValueType;

public final class DefinitionMS
extends IdentifiedMS
implements Definition.State {
    private QName name;
    private QName type;
    private String language;
    private ValueType valueType;
    private Range range;
    private boolean shared;

    public DefinitionMS() {
        this(true);
    }

    public DefinitionMS(boolean shared) {
        this.type = Constants.defaultType;
        this.valueType(Constants.defaultValueType);
        this.range(Constants.defaultRange);
        this.shared(shared);
    }

    public DefinitionMS(String id, Status status) {
        super(id, status);
    }

    public DefinitionMS(Definition.State state) {
        this.name(state.name());
        this.type(state.type());
        this.language(state.language());
        this.valueType(state.valueType());
        this.range(state.range());
        this.shared(state.isShared());
    }

    void shared(boolean flag) {
        this.shared = flag;
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    @Override
    public QName name() {
        return this.name;
    }

    @Override
    public void name(QName name) {
        Utils.valid((String)"name", (QName)name);
        this.name = name;
    }

    @Override
    public QName type() {
        return this.type;
    }

    @Override
    public void type(QName type) {
        this.type = type;
    }

    @Override
    public String language() {
        return this.language;
    }

    @Override
    public void language(String language) {
        this.language = language;
    }

    @Override
    public ValueType valueType() {
        return this.valueType;
    }

    @Override
    public void valueType(ValueType valueType) {
        Utils.notNull((String)"link type", (Object)valueType);
        this.valueType = valueType;
    }

    @Override
    public Range range() {
        return this.range;
    }

    @Override
    public void range(Range range) {
        Utils.notNull((String)"occurrence range", (Object)range);
        this.range = range;
    }

    @Override
    public Definition.Private entity() {
        return new Definition.Private(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Definition.State other = (Definition.State)obj;
        if (this.language == null ? other.language() != null : !this.language.equals(other.language())) {
            return false;
        }
        if (this.name == null ? other.name() != null : !this.name.equals(other.name())) {
            return false;
        }
        if (this.range == null ? other.range() != null : !this.range.equals(other.range())) {
            return false;
        }
        if (this.type == null ? other.type() != null : !this.type.equals(other.type())) {
            return false;
        }
        return !(this.valueType == null ? other.valueType() != null : !this.valueType.equals(other.valueType()));
    }
}

