/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.utils;

import javax.inject.Singleton;
import javax.script.ScriptEngineManager;
import org.cotrix.domain.utils.ScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JavascriptEngine
implements ScriptEngine {
    private static Logger log = LoggerFactory.getLogger(JavascriptEngine.class);
    private static javax.script.ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");

    @Override
    public ScriptEngine.WithClause eval(final String expression) {
        return new ScriptEngine.WithClause(){

            @Override
            public String with(String value) {
                try {
                    log.trace("evaluating \"{}\" with {}", (Object)expression, (Object)(value.isEmpty() ? "<no value>" : ":" + value));
                    engine.put("$value", value);
                    return String.valueOf(engine.eval(expression));
                }
                catch (Exception e) {
                    throw new RuntimeException("cannot evaluate script \n" + expression + "\n over " + value + " (see cause)", e);
                }
            }

            @Override
            public String withNothing() {
                return this.with("<no-value>");
            }
        };
    }
}

