/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.values;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cotrix.domain.utils.ScriptEngineProvider;
import org.cotrix.domain.validation.Constraint;
import org.cotrix.domain.validation.Constraints;
import org.cotrix.domain.values.ValueType;

public final class DefaultType
implements ValueType {
    private boolean required;
    private List<Constraint> constraints = new ArrayList<Constraint>();
    private String dflt = null;

    public DefaultType required() {
        this.required = true;
        return this;
    }

    public DefaultType defaultsTo(String dflt) {
        this.dflt = dflt;
        return this;
    }

    @Override
    public String defaultValue() {
        return this.dflt;
    }

    public DefaultType with(List<Constraint> constraints) {
        this.constraints.addAll(constraints);
        return this;
    }

    public DefaultType with(Constraint ... constraints) {
        return this.with(Arrays.asList(constraints));
    }

    @Override
    public Constraints constraints() {
        return new Constraints(this.constraints);
    }

    @Override
    public boolean isValid(String value) {
        return Boolean.valueOf(ScriptEngineProvider.engine().eval(this.constraints().asSingleConstraint().expression()).with(value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constraints == null ? 0 : this.constraints.hashCode());
        result = 31 * result + (this.dflt == null ? 0 : this.dflt.hashCode());
        result = 31 * result + (this.required ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultType other = (DefaultType)obj;
        if (this.constraints == null ? other.constraints != null : !this.constraints.equals(other.constraints)) {
            return false;
        }
        if (this.dflt == null ? other.dflt != null : !this.dflt.equals(other.dflt)) {
            return false;
        }
        return this.required == other.required;
    }
}

