/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cotrix.common.Utils;
import org.cotrix.domain.memory.IdentifiedMS;
import org.cotrix.domain.trait.Identified;

public interface StateContainer<S>
extends Iterable<S> {
    public int size();

    public void remove(String var1);

    public boolean contains(Identified.State var1);

    public boolean contains(String var1);

    public void add(S var1);

    public Collection<S> get(Collection<String> var1);

    public static class Default<S extends Identified.State>
    implements StateContainer<S> {
        private final Map<String, S> elements = new LinkedHashMap<String, S>();

        public Default() {
            this(Collections.emptyList());
        }

        public Default(Collection<S> elements) {
            Utils.notNull((String)"elements", elements);
            for (Identified.State e : elements) {
                this.add((S)e);
            }
        }

        @Override
        public Iterator<S> iterator() {
            return this.elements.values().iterator();
        }

        @Override
        public boolean contains(String id) {
            return this.elements.containsKey(id);
        }

        @Override
        public boolean contains(Identified.State element) {
            return this.elements.containsValue(element);
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public void add(S element) {
            this.elements.put(element.id(), element);
        }

        @Override
        public void remove(String id) {
            this.elements.remove(id);
        }

        @Override
        public Collection<S> get(Collection<String> ids) {
            ArrayList<S> matches = new ArrayList<S>();
            for (String id : ids) {
                if (!this.elements.containsKey(id)) continue;
                matches.add(this.elements.get(id));
            }
            return matches;
        }

        protected Collection<S> elements() {
            return this.elements.values();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StateContainer)) {
                return false;
            }
            StateContainer other = (StateContainer)obj;
            return !(IdentifiedMS.testmode ? !Utils.collect(this.elements.values()).equals(Utils.collect((Iterable)other)) : !Utils.collectUnordered(this.elements.values()).equals(Utils.collectUnordered((Iterable)other)));
        }
    }
}

