/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.memory;

import java.util.Collection;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.common.NamedStateContainer;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.memory.CodeMS;
import org.cotrix.domain.memory.CodelistLinkMS;
import org.cotrix.domain.memory.DefinitionMS;
import org.cotrix.domain.memory.VersionedMS;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.trait.Status;
import org.cotrix.domain.trait.Versioned;
import org.cotrix.domain.utils.Utils;

public final class CodelistMS
extends VersionedMS
implements Codelist.State {
    private NamedStateContainer<Code.State> codes = new NamedStateContainer.Default<Code.State>();
    private NamedStateContainer<CodelistLink.State> links = new NamedStateContainer.Default<CodelistLink.State>();
    private NamedStateContainer<Definition.State> defs = new NamedStateContainer.Default<Definition.State>();

    public CodelistMS() {
    }

    public CodelistMS(String id, Status status) {
        super(id, status);
    }

    public CodelistMS(Codelist.State state) {
        super(state);
        for (Definition.State atype : state.definitions()) {
            this.defs.add(new DefinitionMS(atype));
        }
        for (CodelistLink.State link : state.links()) {
            this.links.add(new CodelistLinkMS(link));
        }
        for (Code.State code : state.codes()) {
            CodeMS copy = new CodeMS(code);
            copy.attributes().add(this.nameof(code));
            copy.attributes().add(this.idof(code));
            this.codes.add(copy);
        }
        this.attributes().add(this.versionof(state));
        this.attributes().add(this.nameof(state));
        this.attributes().add(this.idof(state));
    }

    @Override
    public NamedStateContainer<Definition.State> definitions() {
        return this.defs;
    }

    @Override
    public NamedStateContainer<CodelistLink.State> links() {
        return this.links;
    }

    public void definitions(Collection<Definition.State> types) {
        org.cotrix.common.Utils.notNull((String)"attribute types", types);
        for (Definition.State type : types) {
            this.defs.add(type);
        }
    }

    public void links(Collection<CodelistLink.State> links) {
        org.cotrix.common.Utils.notNull((String)"links", links);
        for (CodelistLink.State link : links) {
            this.links.add(link);
        }
    }

    public void codes(Collection<Code.State> codes) {
        org.cotrix.common.Utils.notNull((String)"codes", codes);
        for (Code.State code : codes) {
            this.codes.add(code);
        }
    }

    @Override
    public NamedStateContainer<Code.State> codes() {
        return this.codes;
    }

    @Override
    public Codelist.Private entity() {
        return new Codelist.Private(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Codelist.State)) {
            return false;
        }
        Codelist.State other = (Codelist.State)obj;
        if (this.codes == null ? other.codes() != null : !this.codes.equals(other.codes())) {
            return false;
        }
        return !(this.links == null ? other.links() != null : !this.links.equals(other.links()));
    }

    private Attribute.State nameof(Named.State named) {
        return Utils.stateof((Attribute)Codes.attribute().with(CommonDefinition.PREV_VERSION_NAME).value(named.name().toString()).build());
    }

    private Attribute.State idof(Identified.State identified) {
        return Utils.stateof((Attribute)Codes.attribute().with(CommonDefinition.PREV_VERSION_ID).value(identified.id()).build());
    }

    private Attribute.State versionof(Versioned.State versioned) {
        return Utils.stateof((Attribute)Codes.attribute().with(CommonDefinition.PREV_VERSION).value(versioned.version().value()).build());
    }
}

