/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.links;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.links.Link;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.links.LinkValueType;
import org.cotrix.domain.links.NameLink;
import org.cotrix.domain.utils.DomainConstants;

public class LinkOfLink
implements LinkValueType {
    private LinkDefinition target;

    public LinkOfLink(LinkDefinition template) {
        CommonUtils.notNull((String)"template", (Object)template);
        if (Data.reveal(template).isChangeset()) {
            throw new IllegalArgumentException("link template cannot be a changeset");
        }
        this.target = template;
    }

    public LinkDefinition target() {
        return this.target;
    }

    @Override
    public List<Object> valueIn(String id, Code.Bean code, List<String> ids) {
        ArrayList<Object> matches = new ArrayList<Object>();
        for (Link.Bean link : code.links()) {
            LinkDefinition.Bean linktype = (LinkDefinition.Bean)link.definition();
            if (!this.matches(linktype)) continue;
            for (Object match : Link.Private.resolve(link, linktype, ids)) {
                matches.add(match);
            }
        }
        return matches;
    }

    public boolean matches(LinkDefinition link) {
        return this.matches((LinkDefinition.Bean)Data.reveal(link).bean());
    }

    public boolean matches(LinkDefinition.Bean link) {
        QName name = this.target.qname();
        String id = this.target.target() == null ? null : this.target.target().id();
        LinkValueType type = this.target.valueType();
        return this.matches(name, link.qname()) && this.matches(id, link.target()) && this.matches(type == null ? NameLink.INSTANCE : type, link.valueType());
    }

    private boolean matches(String id, Codelist.Bean val) {
        return id == null || val != null && id.equals(val.id());
    }

    private boolean matches(Object templ, Object val) {
        return templ == null || templ.equals(DomainConstants.NULL_QNAME) || templ.equals("__ignore__") || templ.equals(val);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkOfLink other = (LinkOfLink)obj;
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }
}

