/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.common.Container;
import org.cotrix.domain.memory.MIdentified;
import org.cotrix.domain.trait.Named;

public class MContainer<B extends Named.Bean>
implements Container.Bean<B> {
    private final Map<String, B> elements = new LinkedHashMap<String, B>();

    public MContainer() {
    }

    public MContainer(Collection<B> elements) {
        CommonUtils.notNull((String)"elements", elements);
        for (Named.Bean e : elements) {
            this.add(e);
        }
    }

    @Override
    public Iterator<B> iterator() {
        return this.elements.values().iterator();
    }

    @Override
    public B lookup(String id) {
        return (B)((Named.Bean)this.elements.get(id));
    }

    @Override
    public boolean contains(String id) {
        return this.elements.containsKey(id);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public void add(B element) {
        this.elements.put(element.id(), element);
    }

    @Override
    public void remove(String id) {
        this.elements.remove(id);
    }

    @Override
    public Collection<B> get(Collection<String> ids) {
        ArrayList<B> matches = new ArrayList<B>();
        for (String id : ids) {
            if (!this.elements.containsKey(id)) continue;
            matches.add(this.elements.get(id));
        }
        return matches;
    }

    protected Collection<B> elements() {
        return this.elements.values();
    }

    @Override
    public boolean contains(QName name) {
        return !this.get(name).isEmpty();
    }

    @Override
    public Collection<B> get(QName name) {
        ArrayList<Named.Bean> matches = new ArrayList<Named.Bean>();
        for (Named.Bean state : this.elements()) {
            if (!name.equals(state.qname())) continue;
            matches.add(state);
        }
        return matches;
    }

    @Override
    public B getFirst(QName name) {
        Collection<B> matches = this.get(name);
        return (B)(matches.isEmpty() ? null : (Named.Bean)matches.iterator().next());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container.Bean)) {
            return false;
        }
        Container.Bean other = (Container.Bean)obj;
        return !(MIdentified.testmode ? !CommonUtils.collect(this.elements.values()).equals(CommonUtils.collect((Iterable)other)) : !CommonUtils.collectUnordered(this.elements.values()).equals(CommonUtils.collectUnordered((Iterable)other)));
    }
}

