/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.dsl.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Range;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.builder.BuilderUtils;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.LinkDefinitionGrammar;
import org.cotrix.domain.links.AttributeLink;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.links.LinkOfLink;
import org.cotrix.domain.links.NameLink;
import org.cotrix.domain.memory.MLinkDef;
import org.cotrix.domain.utils.AttributeTemplate;
import org.cotrix.domain.values.ValueFunction;

public class LinkDefinitionBuilder {
    private final MLinkDef state;

    public LinkDefinitionBuilder(MLinkDef state) {
        this.state = state;
    }

    public void name(QName name) {
        this.state.qname(name);
    }

    public void name(String name) {
        this.name(Data.q(name));
    }

    public class OptClause
    implements LinkDefinitionGrammar.ThirdClause {
        @Override
        public LinkDefinitionGrammar.ThirdClause anchorTo(Attribute template) {
            LinkDefinitionBuilder.this.state.valueType(new AttributeLink(new AttributeTemplate(template)));
            return this;
        }

        @Override
        public LinkDefinitionGrammar.ThirdClause anchorTo(LinkDefinition template) {
            LinkDefinitionBuilder.this.state.valueType(new LinkOfLink(template));
            return this;
        }

        @Override
        public LinkDefinitionGrammar.ThirdClause anchorToName() {
            LinkDefinitionBuilder.this.state.valueType(NameLink.INSTANCE);
            return this;
        }

        @Override
        public LinkDefinitionGrammar.ThirdClause attributes(Attribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        public LinkDefinitionGrammar.ThirdClause attributes(Collection<Attribute> attributes) {
            LinkDefinitionBuilder.this.state.attributes(BuilderUtils.reveal(attributes, Attribute.Private.class));
            return this;
        }

        @Override
        public LinkDefinitionGrammar.ThirdClause attributes(AttributeGrammar.FourthClause ... clauses) {
            ArrayList as = new ArrayList();
            for (AttributeGrammar.FourthClause clause : clauses) {
                as.add(clause.build());
            }
            return this.attributes((Collection)as);
        }

        @Override
        public LinkDefinitionGrammar.ThirdClause transformWith(ValueFunction function) {
            LinkDefinitionBuilder.this.state.function(function);
            return this;
        }

        @Override
        public LinkDefinitionGrammar.ThirdClause occurs(Range range) {
            LinkDefinitionBuilder.this.state.range(range);
            return this;
        }

        @Override
        public LinkDefinition build() {
            return LinkDefinitionBuilder.this.state.entity();
        }
    }

    public class ChangeClause
    extends OptClause
    implements LinkDefinitionGrammar.LinkDefinitionChangeClause {
        @Override
        public LinkDefinitionGrammar.ThirdClause name(QName name) {
            LinkDefinitionBuilder.this.name(name);
            return this;
        }

        @Override
        public LinkDefinitionGrammar.ThirdClause name(String name) {
            LinkDefinitionBuilder.this.name(name);
            return this;
        }
    }

    public class NewClause
    implements LinkDefinitionGrammar.LinkDefinitionNewClause,
    LinkDefinitionGrammar.SecondClause {
        @Override
        public NewClause name(QName name) {
            LinkDefinitionBuilder.this.name(name);
            return this;
        }

        @Override
        public NewClause name(String name) {
            LinkDefinitionBuilder.this.name(name);
            return this;
        }

        @Override
        public LinkDefinitionGrammar.ThirdClause target(Codelist target) {
            CommonUtils.notNull((String)"codelist", (Object)target);
            Codelist.Private list = Data.reveal(target);
            if (list.isChangeset()) {
                throw new IllegalArgumentException("invalid link: target codelist cannot be a changeset");
            }
            LinkDefinitionBuilder.this.state.target((Codelist.Bean)list.bean());
            return new OptClause();
        }
    }
}

