/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.memory;

import javax.xml.namespace.QName;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.attributes.Facet;
import org.cotrix.domain.common.Range;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.memory.MDescribed;
import org.cotrix.domain.utils.DomainConstants;
import org.cotrix.domain.values.ValueType;

public final class MAttrDef
extends MDescribed
implements AttributeDefinition.Bean {
    private QName type;
    private String language;
    private ValueType valueType;
    private Range range;
    private boolean shared;

    public MAttrDef() {
        this(true);
    }

    public MAttrDef(boolean shared) {
        this.type(DomainConstants.defaultType);
        this.valueType(DomainConstants.defaultValueType);
        this.range(DomainConstants.defaultRange);
        this.shared(shared);
    }

    public MAttrDef(String id, Status status) {
        super(id, status);
    }

    public MAttrDef(AttributeDefinition.Bean other) {
        super(other);
        this.type(other.type());
        this.language(other.language());
        this.valueType(other.valueType());
        this.range(other.range());
        this.shared(other.isShared());
    }

    void shared(boolean flag) {
        this.shared = flag;
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    @Override
    public QName type() {
        return this.type;
    }

    @Override
    public void type(QName type) {
        this.type = type;
    }

    @Override
    public boolean is(QName name) {
        return this.type.equals(name);
    }

    @Override
    public boolean is(Facet facet) {
        return !CommonDefinition.isCommon(this.qname()) || CommonDefinition.isCommon(this.qname(), facet);
    }

    @Override
    public String language() {
        return this.language;
    }

    @Override
    public void language(String language) {
        this.language = language;
    }

    @Override
    public ValueType valueType() {
        return this.valueType;
    }

    @Override
    public void valueType(ValueType valueType) {
        CommonUtils.notNull((String)"link type", (Object)valueType);
        this.valueType = valueType;
    }

    @Override
    public Range range() {
        return this.range;
    }

    @Override
    public void range(Range range) {
        CommonUtils.notNull((String)"occurrence range", (Object)range);
        this.range = range;
    }

    @Override
    public AttributeDefinition.Private entity() {
        return new AttributeDefinition.Private(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AttributeDefinition.Bean other = (AttributeDefinition.Bean)obj;
        if (this.language == null ? other.language() != null : !this.language.equals(other.language())) {
            return false;
        }
        if (this.range == null ? other.range() != null : !this.range.equals(other.range())) {
            return false;
        }
        if (this.type == null ? other.type() != null : !this.type.equals(other.type())) {
            return false;
        }
        return !(this.valueType == null ? other.valueType() != null : !this.valueType.equals(other.valueType()));
    }
}

