/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.gcube.extension;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.action.Action;
import org.cotrix.action.UserAction;
import org.cotrix.common.BeanSession;
import org.cotrix.common.CommonUtils;
import org.cotrix.common.events.Current;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.gcube.extension.PortalProxy;
import org.cotrix.gcube.extension.PortalProxyProvider;
import org.cotrix.gcube.extension.PortalRole;
import org.cotrix.gcube.extension.RequestLifecycle;
import org.cotrix.gcube.extension.RoleMapper;
import org.cotrix.gcube.stubs.PortalUser;
import org.cotrix.gcube.stubs.SessionToken;
import org.cotrix.io.CloudService;
import org.cotrix.repository.UserQueries;
import org.cotrix.repository.UserRepository;
import org.cotrix.security.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.workspace.WorkspacePlugin;
import org.virtualrepository.RepositoryService;

@Alternative
@Priority(value=1000)
@Singleton
public class GCubeRealm
implements Realm {
    private Logger logger = LoggerFactory.getLogger(GCubeRealm.class);
    @Inject
    private PortalProxyProvider safePortalUrlProvider;
    @Inject
    private PortalProxyProvider portalProxyProvider;
    @Inject
    private UserRepository userRepository;
    @Inject
    private RoleMapper roleMapper;
    @Inject
    private CloudService cloud;
    @Inject
    @Current
    private BeanSession session;
    @Inject
    private RequestLifecycle lifecycle;
    private ExecutorService asyncPool = Executors.newCachedThreadPool();

    public boolean supports(Object token) {
        return token instanceof SessionToken;
    }

    public String login(Object token) {
        SessionToken stoken = (SessionToken)CommonUtils.reveal((Object)token, SessionToken.class);
        PortalProxy portalProxy = this.portalProxyProvider.getPortalProxy(stoken);
        this.session.add(PortalProxy.class, (Object)portalProxy);
        PortalUser external = portalProxy.getPortalUser();
        User internal = (User)this.userRepository.get(UserQueries.userByName((String)external.userName()));
        if (internal == null) {
            internal = this.intern(external);
        } else {
            this.update(external, internal);
        }
        this.initSession(stoken, internal);
        return external.userName();
    }

    private void initSession(SessionToken token, final User user) {
        this.lifecycle.init(token, user);
        int timeout = 120000;
        for (final RepositoryService service : this.cloud.repositories()) {
            if (!service.name().equals(WorkspacePlugin.name)) continue;
            this.asyncPool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        GCubeRealm.this.cloud.discover(120000, new RepositoryService[]{service});
                    }
                    catch (Exception e) {
                        GCubeRealm.this.logger.error("cannot refresh cloud for " + user.name());
                    }
                }
            });
            break;
        }
        this.session.add(SessionToken.class, (Object)token);
    }

    private User intern(PortalUser external) {
        this.logger.info("interning external gCube user: {}", (Object)external);
        Collection<Role> roles = this.roleMapper.map(external.roles());
        User user = Users.user().name(external.userName()).fullName(external.fullName()).email(external.email()).is(roles).build();
        this.userRepository.add((Object)user);
        User changeset = Users.modifyUser((User)user).can(new Action[]{UserAction.VIEW.on(user.id())}).build();
        this.userRepository.update((Object)changeset);
        return user;
    }

    private void update(PortalUser external, User internal) {
        this.logger.trace("updating internal user from external gCube user: {}", (Object)external);
        Collection<Role> roles = this.roleMapper.map(external.roles());
        User modified = Users.modifyUser((User)internal).fullName(external.fullName()).email(external.email()).isNoLonger(PortalRole.roles()).is(roles).build();
        this.userRepository.update((Object)modified);
    }

    public void add(String name, String pwd) {
        throw new UnsupportedOperationException("sign up active only through iMarine portal");
    }
}

