/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.gcube.stubs;

import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class SessionToken {
    private static final String ENCODING = "UTF-8";
    private static final Gson converter = new Gson();
    private final String id;
    private final String scope;
    private final String origin;

    public SessionToken(String id, String scope, String origin) {
        this.id = id;
        this.scope = scope;
        this.origin = origin;
    }

    public String id() {
        return this.id;
    }

    public String scope() {
        return this.scope;
    }

    public String origin() {
        return this.origin;
    }

    public String encoded() {
        try {
            return URLEncoder.encode(converter.toJson((Object)this), ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("cannot encode token", e);
        }
    }

    public static SessionToken valueOf(String encoded) {
        try {
            return (SessionToken)converter.fromJson(URLDecoder.decode(encoded, ENCODING), SessionToken.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("cannot decode token " + encoded + " (see cause) ", e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Token [sessionId=");
        builder.append(this.id);
        builder.append(", scope=");
        builder.append(this.scope);
        builder.append(", portalUrl=");
        builder.append(this.origin);
        builder.append("]");
        return builder.toString();
    }
}

