/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.impl;

import java.util.Iterator;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.cotrix.common.Utils;
import org.cotrix.io.CloudService;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.virtualrepository.Asset;
import org.virtualrepository.AssetType;
import org.virtualrepository.Property;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.VirtualRepository;
import org.virtualrepository.csv.CsvCodelist;
import org.virtualrepository.sdmx.SdmxCodelist;
import org.virtualrepository.tabular.Table;

public class DefaultCloudService
implements Iterable<Asset>,
CloudService {
    public static final AssetType[] publicationTypes = new AssetType[]{SdmxCodelist.type};
    public static final AssetType[] importTypes = new AssetType[]{SdmxCodelist.type, CsvCodelist.type};
    private final VirtualRepository repository;

    @Inject
    public DefaultCloudService(VirtualRepository repository) {
        this.repository = repository;
    }

    @Override
    public int discover() {
        return this.repository.discover(importTypes);
    }

    @Override
    public int discover(int timeout) {
        return this.repository.discover((long)timeout, importTypes);
    }

    @Override
    public <T> T retrieve(String id, Class<T> type) {
        return (T)this.repository.retrieve(this.repository.lookup(id), type);
    }

    @Override
    public CodelistBean retrieveAsSdmx(String id) {
        return (CodelistBean)this.repository.retrieve(this.repository.lookup(id), CodelistBean.class);
    }

    @Override
    public Table retrieveAsTable(String id) {
        return (Table)this.repository.retrieve(this.repository.lookup(id), Table.class);
    }

    @Override
    public void publish(CodelistBean list, QName name) {
        Utils.notNull((String)"list", (Object)list);
        Utils.notNull((String)"repository name", (Object)name);
        RepositoryService service = this.repository.services().lookup(name);
        this.repository.publish((Asset)new SdmxCodelist(list.getId(), service), (Object)list);
    }

    @Override
    public void publish(Table list, QName name) {
        Utils.notNull((String)"list", (Object)list);
        Utils.notNull((String)"repository name", (Object)name);
        RepositoryService service = this.repository.services().lookup(name);
        this.repository.publish((Asset)new CsvCodelist("name", 0, service, new Property[0]), (Object)list);
    }

    @Override
    public Iterable<RepositoryService> repositories() {
        return this.repository.services();
    }

    @Override
    public Iterator<Asset> iterator() {
        return this.repository.iterator();
    }
}

